#include "stdafx.h"
#include "PropDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CPropDlg::CPropDlg(CAddrBook::Entry entry) : CDialog(IDD_MUDPROPS, NULL)
{ Entry = entry;
}

BOOL CPropDlg::OnInitDialog()
{ CDialog::OnInitDialog();
  TCHAR   buf[8];
  CWnd   *wnd;
  (wnd=GetDlgItem(IDC_NAME))->SendMessage(EM_LIMITTEXT, 255);
  wnd->SetWindowText(Entry.name.c_str());
  (wnd=GetDlgItem(IDC_NAME))->SendMessage(EM_LIMITTEXT, 255);
  wnd->SetWindowText(Entry.address.c_str());
  (wnd=GetDlgItem(IDC_NAME))->SendMessage(EM_LIMITTEXT, 255);
  wnd->SetWindowText(Entry.comment.c_str());
  (wnd=GetDlgItem(IDC_PORT))->SendMessage(EM_LIMITTEXT, 5);
  wsprintf(buf, _T("%d"), Entry.port);
  wnd->SetWindowText(buf);
  (wnd=GetDlgItem(IDC_WIDTH))->SendMessage(EM_LIMITTEXT, 3);
  wsprintf(buf, _T("%d"), Entry.port);
  wnd->SetWindowText(buf);
  (wnd=GetDlgItem(IDC_HEIGHT))->SendMessage(EM_LIMITTEXT, 3);
  wsprintf(buf, _T("%d"), Entry.port);
  wnd->SetWindowText(buf);
  (wnd=GetDlgItem(IDC_SCROLLBACK))->SendMessage(EM_LIMITTEXT, 5);
  wsprintf(buf, _T("%d"), Entry.port);
  wnd->SetWindowText(buf);
  GetDlgItem(IDC_ECHO)->SendMessage(BM_SETCHECK, Entry.bEcho);
  return TRUE;
}

void CPropDlg::OnOK()
{ TCHAR buf[256];
  CEdit edit;
  int port;
  bool ret=true;

  edit.Attach(GetDlgItem(IDC_NAME)->m_hWnd);
  if(edit.LineLength() <= 0)
  { AfxMessageBox(_T("Please enter a name."));
    ret = false;
    goto Done;
  }

  edit.Detach();
  edit.Attach(GetDlgItem(IDC_ADDRESS)->m_hWnd);
  if(edit.LineLength() <= 0)
  { AfxMessageBox(_T("Please enter an address."));
    ret = false;
    goto Done;
  }

  port = atoi(GetLine(IDC_PORT, buf));
  if(port < 0 || port > 65535)
  { AfxMessageBox(_T("The port must be from 0 to 65535."));
    ret = false;
    goto Done;
  }

  Done:
  if(!ret) edit.SetFocus();
  edit.Detach();
  if(ret)
  { Entry.name    = GetLine(IDC_NAME, buf);
    Entry.address = GetLine(IDC_ADDRESS, buf);
    Entry.comment = GetLine(IDC_COMMENT, buf);
    Entry.port    = atoi(GetLine(IDC_PORT, buf));
    Entry.width   = atoi(GetLine(IDC_WIDTH, buf));
    Entry.height  = atoi(GetLine(IDC_HEIGHT, buf));
    Entry.scroll  = atoi(GetLine(IDC_SCROLLBACK, buf));
    Entry.bEcho   = GetDlgItem(IDC_ECHO)->SendMessage(BM_GETCHECK) != 0;
    CDialog::OnOK();
  }
}

TCHAR * CPropDlg::GetLine(int id, TCHAR *buf)
{ GetDlgItem(id)->GetWindowText(buf, 256);
  return buf;
}
