#ifndef SSTRING_H_INC
#define SSTRING_H_INC

class SString
{ public:
    SString()           { Str = NULL; nMax=0;  }
    SString(TCHAR *str) { nMax=0; *this = str; }
    ~SString()          { Free(); }

    void          Set(const TCHAR *);
    TCHAR *       Get()          { return Str; }
    const TCHAR * Get()    const { return Str; }
    int           Length() const { return Str ? _tcslen(Str) : 0; }
    void          Free();

    bool operator==(const TCHAR *rhs) const { return Str ? !_tcscmp(Str, rhs) : Str==rhs; }
    operator TCHAR *()                      { return Get(); }
    operator const TCHAR *() const          { return Get(); }

    TCHAR *Str;

  private:
    int    nMax;
};

#endif
