#include "stdafx.h"
#include "Telnet.h"
#include "TextCont.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CTelnet::CTelnet()
{ Parent = NULL;
  bConn  = bSend = false;
}

void CTelnet::Close()
{ OnClose(-10);
  CAsyncSocket::Close();
}

int CTelnet::Send(const void* lpBuf, int nBufLen, int nFlags)
{ if(!bSend) return SOCKET_ERROR;
  if(Parent->Entry.bEcho && !(g_MyApp.Props.bConceal && Parent->Container.Concealed()))
    Parent->Container.AddData((const char*)lpBuf, nBufLen);
  return CAsyncSocket::Send(lpBuf, nBufLen, nFlags);
}

void CTelnet::SendLine(const TCHAR *line)
{ char buf[4096];
  TCharToChar(buf, line);
  int len=strlen(buf);
  buf[len] = '\n';
  Send(buf, len+1);
}

void CTelnet::OnSend(int err)
{ bSend = (err == 0);
  CAsyncSocket::OnSend(err);
}

void CTelnet::OnReceive(int err)
{ if(err) return;
  char buf[4096];
  int  read;

  read = Receive(buf, 4096); 
  if(read == 0) Close();
  else if(read == SOCKET_ERROR) assert(0);
  else Parent->Container.AddData(buf, read);
  CAsyncSocket::OnReceive(err);
}

void CTelnet::OnConnect(int err)
{ bConn = (err == 0);
  CAsyncSocket::OnConnect(err);
}

void CTelnet::OnClose(int err)
{ bConn = bSend = false;
  CAsyncSocket::OnClose(err);
  if(err != -10 && g_MyApp.Props.bNotify) AfxMessageBox(_T("Connection Lost"));
}
