#include "stdafx.h"
#include "TextCont.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CTextCont::CTextCont()
{ Buffer    = new TCHAR[bufLen=8192];
  Lines     = new int[maxLines=256];
  bufPos    = linePos = 0;
  bConceal  = bBold = false;
  Parent    = NULL;
  Buffer[0] = 0;
}

CTextCont::~CTextCont()
{ delete[] Buffer;
  delete[] Lines;
}

void CTextCont::Resize(int chars)
{ if(chars<4096) chars=4096;
  else chars=(chars+1024)&~1023;
  TCHAR *buf = new TCHAR[bufLen=chars];
  if(chars>bufLen) Clear();
  else memcpy(buf, Buffer, (bufPos+1)*sizeof(TCHAR));
  delete[] Buffer;
  Buffer = buf;
}

void CTextCont::Clear()
{ Buffer[bufPos=0] = 0;
  linePos=0;
}

int CTextCont::AddData(const char *buf, int len)
{ if(len)
  { int opos;
    if(!linePos) Lines[0]=0, linePos=1;
    if(bufPos+len >= bufLen) MakeRoom(len+1);
    assert(bufPos+len <= bufLen);
    opos = bufPos?bufPos-1:0;
    CharToTCharBuf(Buffer+bufPos, buf, len);
    Buffer[bufPos+=len] = 0;
    bufPos = Strip(Buffer+opos) + opos;
    Stringize(++opos);
    bChanged=true;
    Parent->AddToLog(Buffer+opos);
  }
  return linePos;
}

bool CTextCont::Changed()
{ bool b=bChanged;
  bChanged=false;
  return b;
}

void CTextCont::Render(CDC *cdc, int sline, int lines, int ystart, int xoff, int yoff)
{ bBold = false;
  SetColor(cdc, -1, false);
  SetColor(cdc, -1, true);
  ystart -= yoff;
  while(lines-- && sline<linePos) WriteLine(cdc, sline++, ystart+=yoff, xoff, yoff);
}

const TCHAR * CTextCont::GetLine(int index)
{ assert(index>=0 && index<linePos);
  return Buffer+Lines[index];
}

int CTextCont::MakeRoom(int len)
{ int free = bufLen-bufPos, li, adjust=0, remed=0;
  
  for(li=1; free<len && li<linePos-1; li++)
  { int dist = Lines[li]-Lines[li-1];
    free += dist, adjust += dist;
    remed++;
  }
  if(li>=linePos)
  { int needed = len-free;
    Resize(bufLen+needed);
  }
  memmove(Lines, Lines+remed, (linePos-=remed)*sizeof(int));
  for(int i=0;i<linePos;i++) Lines[i]-=adjust;
  memmove(Buffer, Buffer+adjust, (bufPos-=adjust)*sizeof(TCHAR));
  return adjust;
}

int CTextCont::Strip(TCHAR *buf)
{ int i, j, len = _tcslen(buf);
  for(i=j=0; j<len; i++,j++)
  { TCHAR c = buf[j];
    if(c == '\r' || c == '\n')
    { buf[i] = '\n';
      TCHAR nc = buf[j+1];
      if((j+1)<bufPos && (nc == '\r' || nc == '\n') && nc != c) j++;
    }
    else if(c == 0x1b)
    { int v=j;
      ReadAnsi(buf, v, len);
      v-=j-1;
      while(j<len && v--) buf[i++]=buf[j++];
      i--,j--;
    }
    else if(c<32 || c>126) i--;
    else buf[i] = buf[j];
  }
  buf[i] = 0;
  return i;
}

void CTextCont::Stringize(int pos)
{ for(;pos<bufPos;pos++) if(Buffer[pos] == '\n') Lines[linePos++] = pos+1;
}

void CTextCont::WriteLine(CDC *cdc, int line, int ypos, int xoff, int yoff)
{ static int sX, sY;
  TCHAR *pline = Buffer+Lines[line];
  int i, end=line<linePos-1?Lines[line+1]:bufPos-Lines[line], len=0, x=xoff;

  for(i=0; i<end && pline[i]!='\n'; i++)
  { TCHAR c = pline[i];
    if(c == 0x1b || c == '\b')
    { if(len)
      { cdc->TextOut(x, ypos, pline+i-len, len);
        x+=xoff*len;
        len=0;
      }
      if(c == 0x1b) // escape code
      { const char *ansi = ReadAnsi(pline, i, end), *parm;
        if(!ansi) break;
        int len  = strlen(ansi+=2), n;
        c = ansi[len-1]; // command
        switch(c)
        { case 'm':
            { int j=0;
              while(parm=GetParm(ansi, j++))
              { n = atoi(parm);
                if(n==0)
                { bConceal = bBold = false;
                  SetColor(cdc, -1, false);
                  SetColor(cdc, -1, true);
                }
                else if(n>30 && n<38) SetColor(cdc, n-30, false);
                else if(n>40 && n<48) SetColor(cdc, n-40, true);
                else if(n==1)
                { bBold = true;
                  SetColor(cdc, -1, false);
                }
                else if(n==7) SetColor(cdc, -2);
                else if(n==8) bConceal = true;
              }
            }
            break;

          case 'H': case 'f':
            n = (parm=GetParm(ansi, 0)) ? atoi(parm) : 0;
            x = xoff*(n+1);
            n = (parm=GetParm(ansi, 1)) ? atoi(parm) : 0;
            ypos = yoff*(n+1);
            break;

          case 'A': case 'B':
            if(parm=GetParm(ansi))
            { n = atoi(parm);
              ypos += (c == 'A' ? yoff*-n : yoff*n);
              if(ypos<0) ypos=0;
            }
            break;

          case 'C': case 'D':
            if(parm=GetParm(ansi))
            { n = atoi(parm);
              x += (c == 'D' ? xoff*-n : xoff*n);
              if(x<xoff) x=0;
            }
            break;

          case 's': sX=x, sY=ypos; break;
          case 'u': x=sX, ypos=sY; break;
        }
      } 
      else if((x-=xoff) < xoff) x=xoff;
    }
    else len++;
  }
  if(len) cdc->TextOut(x, ypos, pline+i-len, len);
}

void CTextCont::SetColor(CDC *cdc, int color, bool back)
{ if(color == -1) color = back ? g_defBack : g_defFore;
  if(color == -2)
  { cdc->SetBkColor(g_Colors[cFore]);
    cdc->SetTextColor(g_Colors[cBack]);
    return;
  }
  if(back) cdc->SetBkColor(g_Colors[cBack=color]);
  else
  { if(color<8 && bBold) color+=8;
    cdc->SetTextColor(g_Colors[cFore=color]);
  }
}

const char * CTextCont::ReadAnsi(TCHAR *line, int &i, int end)
{ int j=0;
  if(i==end) return NULL;
  do Ansi[j++] = line[i++]; while(i<end && !isAlpha(Ansi[j-1]));
  i--;
  if(!isAlpha(Ansi[j-1])) return NULL;
  Ansi[j] = 0;
  return Ansi;
}

const char * CTextCont::GetParm(const char *ansi, int pnum)
{ int i=0, j, len = strlen(ansi);

  do
  { TCHAR c;
    j=0;
    while((c=ansi[i]) && c!=';' && Classify(c)!=A_PARM) i++;
    while((c=ansi[i]) && Classify(c) == A_PARM) Parm[j++] = ansi[i++];
    Parm[j] = 0;
    i++;
  } while(pnum--);
  if(!Parm[0]) return NULL;
  return Parm;
}

int CTextCont::Classify(TCHAR &c)
{ TCHAR rc = c;
  if(rc==0x7f || rc==0xa0 || rc==0xff) return A_IGNR;
  if(rc>0xa0) rc&=0x7f;
  if(rc < 0x20) return A_CTRL;
  if(rc>=0x20 && rc<=0x2f) return A_INTR;
  if(rc>=0x30 && rc<=0x3f) return A_PARM;
  if(rc>=0x40 && rc<=0x5f) return A_UPPR;
  if(rc>=0x60 && rc<=0x7f) return A_LOWR;
  return A_IGNR;
}
