#ifndef TEXTCONT_H_INC
#define TEXTCONT_H_INC

class CMainFrm;
class CTextCont
{ public:
    CTextCont();
    ~CTextCont();

    void SetParent(CMainFrm *par) { Parent = par; }
    void Resize(int chars);
    void Clear();

    int   AddData(const char *, int len);
    int   NumLines() { return linePos; }
    bool  Changed();
    bool  Concealed() { return bConceal; }
    void  Render(CDC *cdc, int sline, int lines, int ystart, int xoff, int yoff);
    const TCHAR * GetLine(int index);

  private:
    enum { A_IGNR, A_CTRL, A_INTR, A_PARM, A_UPPR, A_LOWR };
    int  MakeRoom(int len);
    int  Strip(TCHAR *buf);
    void Stringize(int pos);
    void WriteLine(CDC *cdc, int line, int ypos, int xoff, int yoff);
    void SetColor(CDC *cdc, int color, bool back=false);
    bool isAlpha(char c) { return (c>='A' && c<='Z') || (c>='a' && c<='z'); }
    const char * ReadAnsi(TCHAR *line, int &i, int end);
    const char * GetParm(const char *ansi, int parm=0);
    int  Classify(TCHAR &c);

    char   Ansi[64], Parm[64];
    CMainFrm *Parent;
    TCHAR    *Buffer;
    int      *Lines;
    int       bufLen, maxLines, linePos, bufPos;
    int       cFore, cBack;
    bool      bBold, bChanged, bConceal;
};

#endif
