#include "stdafx.h"
#include "globals.h"
#include <stdio.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

int TrimString(TCHAR *str)
{ int s=0, e=_tcslen(str)-1;
  for(;s<=e;s++) if(!isspace(str[s])) break;
  for(;e>s;e--)  if(!isspace(str[e])) break;
  str[++e] = 0;
  if(s) memmove(str, str+s, (e-s+1)*sizeof(TCHAR));
  return e-s;
}

CString& GetWord(TCHAR const *str, int wnum)
{ static CString string;
  TCHAR word[4096];
  int i=0, len=_tcslen(str);
  word[0]=0;
  do
  { int j=0;
    for(;i<len;i++) if(!isspace(str[i])) break;
    for(;i<len;i++)
    { if(isspace(str[i])) break;
      word[j++] = str[i];
    }
    word[j] = 0;
  } while(wnum--);
  string=word;
  return string;
}

void CharToTChar(TCHAR *dest, const char *src)
{
#ifdef _UNICODE
  int len = strlen(src);
  for(int i=0;i<=len;i++) dest[i] = src[i];
#else
  strcpy(dest, src);
#endif
}

void TCharToChar(char *dest, const TCHAR *src)
{
#ifdef _UNICODE
  int len = strlen(src);
  for(int i=0;i<=len;i++) dest[i] = (char)src[i];
#else
  strcpy(dest, src);
#endif
}

void CharToTCharBuf(TCHAR *dest, const char *src, int len)
{
#ifdef _UNICODE
  for(int i=0;i<len;i++) dest[i] = src[i];
#else
  memcpy(dest, src, len);
#endif
}

FILE * OpenFile(const TCHAR *name, bool ovr)
{ TCHAR fn[MAX_PATH];
  _tcscpy(fn, g_MyApp.GetPath());
  _tcscat(fn, name);
  FILE *ret = fopen(fn, ovr ? _T("wb+") : _T("rb+"));
  if(!ret && ovr) AfxMessageBox(CString(_T("Unable to open file: ")) + fn);
  return ret;
}

const TCHAR * ReadString(FILE *file)
{ static TCHAR line[1024];
  int len;
  fread(&len, sizeof(int), 1, file);
  fread(line, len*sizeof(TCHAR), 1, file);
  return line;
}

void WriteString(FILE *file, const TCHAR *str)
{ int len = _tcslen(str)+1;
  fwrite(&len, sizeof(int), 1, file);
  fwrite(str, len*sizeof(TCHAR), 1, file);
}

COLORREF g_Colors[16] =
{ RGB(0,0,0), RGB(192,0,0), RGB(0,192,0), RGB(192,192,0), RGB(0,0,192),
  RGB(192,0,192), RGB(0,192,192), RGB(192,192,192), RGB(192,192,192),
  RGB(255,0,0), RGB(0,255,0), RGB(255,255,0), RGB(0,0,255), RGB(255,0,255),
  RGB(0,255,255), RGB(255,255,255)
};

int g_defFore=7, g_defBack=0;
