#include <assert.h>
#include <vector>
#include "Entities\Item.h"

#define FIRSTITEM 1024

std::vector<Entities::Item *>  Items;
int NumItems;

int GetItemIndex(DWORD ID); // returns the index of an item or -1 if not found

void AddItem(Entities::Item *item)
{
   if (NumItems == Items.size()) Items.resize(NumItems + 50);
   Items[NumItems++] = item;
} /* AddItem */


void RemItem(DWORD ID)
{
   int last = --NumItems, pos = GetItemIndex(ID);
   assert(pos != -1 && NumItems);

   Items[pos]  = Items[last];
   Items[last] = NULL;
} /* RemItem */


void ClearItems()
{
   for(int i=0;i<NumItems;i++) delete Items[i];
   Items.resize(0);
   NumItems = 0;
} /* ClearItems */


DWORD NewItemID()
{
   static DWORD NextID = FIRSTITEM;
   return NextID++;
} /* NewItemID */


Entities::Item *FindItem(DWORD ID)
{
   for(int i=0;i<NumItems;i++)
      if (Items[i]->ID == ID) return Items[i];
   return NULL;
} /* FindItem */


int GetItemIndex(DWORD ID)
{
   for(int i=0;i<NumItems;i++)
      if (Items[i]->ID == ID) return i;
   return -1;
} /* GetItemIndex */
