#include <windows.h>
#include <signal.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <time.h>
#include "Binfile\BinfStd.h"
#include "PrintQueue.h"
#include "Network.h"
#include "Items.h"

#define VERSION "0.01a"

void Die(int retcode, char const *str, ...); // print a message, and exit app
int  InitServer();                        // initialize the server for use
void DeinitServer();                      // deinit the server...
void HandleInput();                       // handle the console input
void GetLine(char *line, int len);        // retrieve and strips a line of text
char Prompt(char const *prompt);          // asks a yes or no question. returns 'Y', 'N'

static volatile bool bQuitApp;
static bool bSessionHosted;

static char *g_AppPath;

struct ExitStruct
{
   int RetCode;
};
void Die(int retcode, char const *str, ...)
{
   char buf[512];
   va_list list;
   ExitStruct es;

   va_start(list, str);
   vsprintf(buf, str, list);
   fputs(buf, stderr);
   va_end(list);

   es.RetCode = retcode;
   throw(es);
} /* Die */


int InitServer()
{
   LARGE_INTEGER LI;
   sbinfile file;
   char buf[256];

   if (!QueryPerformanceFrequency(&LI)) return 1;

   Entities::OnlyObjectFactory.Hush(true);
   strcpy(buf, g_AppPath);
   strcat(buf, "Items.dat");
   if (file.open(buf, file.openro | file.openex)) return 2;
   if (Entities::OnlyItemFactory.Load(&file)) return 3;
   file.close();

   if (InitPrintQueue()) return 4;
   if (FAILED(CoInitialize(NULL))) return 5;
   if (InitNetwork())    return 6;
   srand(time(NULL));

   return 0;
} /* InitServer */


void DeinitServer()
{
   DeinitNetwork();
   CoUninitialize();
   DeinitPrintQueue();

   puts("Ronx Server shutdown.");
} /* DeinitServer */


void HandleInput()
{
   if (!kbhit()) return;
   const int INPLEN = 256;

   char Input[INPLEN];

   StopPrintQueue();

   printf("RS> ");
   GetLine(Input, INPLEN);

   switch(toupper(Input[0]))
   {
      case '?':
         puts("?        - This help text.\n"
              "H [name] - Host a session.\n"
              "S        - Stop the session.\n"
              "Q        - Quits the server.");
         break;

      case 'H':
         {
            bool dohost = true;
            if (bSessionHosted)
            {
               char c = Prompt("There is already a session hosted. Do you wish to stop it (Y/N)? ");
               if (c == 'Y')
               {
                  EndSession();
                  bSessionHosted = false;
               }
               else dohost = false;
            }
            if (dohost)
            {
               char *input = Input;
               int   ret;
               if (Input[1]) input += 2;
               else
               {
                  printf("New Session Name: ");
                  GetLine(input, INPLEN);
               }
               if (ret = HostSession(input)) printf("Hosting failed: Error %d\n", ret);
               else
               {
                  bSessionHosted = true;
                  puts("Session hosted!");
               }
            }
         }
         break;

      case 'S':
         if(!bSessionHosted) puts("No session is currently hosted!");
         else
         {
            char c = Prompt("Really end session (Y/N)? ");
            if (c == 'Y')
            {
               EndSession();
               bSessionHosted = false;
               puts("Session ended.");
            }
            else puts("Session still running.");
         }
         break;
               
      case 'Q':
         {
            bQuitApp = (Prompt("Quit: Are you sure (Y/N)? ") == 'Y');
         }
         break;
   }
   
   putchar('\n');
   ResumePrintQueue();
} /* HandleInput */


void GetLine(char *line, int len)
{
   int i;

   fgets(line, len, stdin);
   
   i = strlen(line);
   do
   {
      i--;
   } while(line[i] == '\n' || line[i] == '\r');
   i++;

   int start, end;
   for(start=0;start<i;start++) if (!isspace(line[start])) break;
   for(end=i-1;end;end--)       if (!isspace(line[end]))   break;

   if (start) CopyMemory(line, line+start, end-start+1);
   line[end+1] = 0;
} /* GetLine */


char Prompt(char const *prompt)
{
   char Input[8];

   while(TRUE)
   {
      printf(prompt);
      GetLine(Input, 8);
      char c = toupper(Input[0]);
      if (c == 'Y' || c == 'N') return c;
   }
   return 0;
} /* Prompt */


int main(int argc, char *argv[])
{
   try
   {
      signal(SIGINT, SIG_IGN);      // dont let Ctrl-C and Ctrl-Brk kill us
      
      int i;
      for(i=strlen(argv[0])-1;i>=0;i--) if (argv[0][i] == '\\') break;
      i++;
      g_AppPath = new char[i + 1];
      CopyMemory(g_AppPath, argv[0], i);
      g_AppPath[i] = 0;

      int ret = InitServer();
      if (ret) Die(ret, "Error %d Initializing server!\n", ret);
      QueueMessage("Ronx Server " VERSION " Initialized.\n"
                   "Use the ? command for help.\n\n");

      while (!bQuitApp)
      {
         HandleInput();
         Sleep(10);
      }
   }
   catch(ExitStruct es) // catch a Die()
   {
      DeinitServer();
      return es.RetCode;
   }
   catch(...)           // catch anything else
   {
      DeinitServer();
      fputs("Unhandled exception.\n", stderr);
      return -1;
   }
   DeinitServer();      // successful exit
   return 0;
} /* main */
