#include <windows.h>
#include <vector>
#include <dplay.h>
#include "Entities\Item.h"
#include "Binfile\binfmem.h"
#include "Msgs.h"

#include "Network\NetMsgs.h"  // Special purpose file

static void *RecvBuffer;
static DWORD RecvBufLen;
static void *SendBuffer;
static DWORD SendBufLen;
struct myPlayer
{
   DWORD ID;
   std::string Name;
};
static std::vector<myPlayer *> Players;

void EnlargeSendBuf(DWORD newsize)
{
   if (SendBufLen < newsize)
   {
      if (SendBuffer) delete[] SendBuffer;
      SendBuffer = new char[SendBufLen = newsize];
   }
} /* EnlargeSendBuf */


void EnlargeRecvBuf(DWORD newsize)
{
   if (RecvBufLen < newsize)
   {
      if (RecvBuffer) delete[] RecvBuffer;
      RecvBuffer = new char[RecvBufLen = newsize];
   }
} /* EnlargeRecvBuf */


int SendMessage(DWORD idTo, void *msg, DWORD msglen, bool guar)
{
   HRESULT hRet;
   DWORD flags = DPSEND_ASYNC;

   if (guar) flags |= DPSEND_GUARANTEED;

   hRet = BDP.GetDP()->SendEx(NetID, idTo, flags, msg, msglen, 0, 0, NULL, NULL);
   if (FAILED(hRet) && hRet != DPERR_PENDING)
   {
      puts("Error sending message.");
      return hRet;
   }

   return 0;
} /* SendMessage */


int FindPlayer(DWORD ID)
{
   int i, num = Players.size();

   for(i=0;i<num;i++) if (Players[i]->ID == ID) return i;
   return -1;
} /* FindPlayer */


void ProcessLogOn(DWORD ID)
{
   MsgLogOn *inmsg = (MsgLogOn *)RecvBuffer;
   DWORD msglen = sizeof(MsgLogOnAccepted) + sizeof(MLO_PlayerList) + sizeof(MPL_OnePlayer) + sizeof(Vectors::VectObject) + 50;
   int num = Players.size();
   Entities::Item item;
   mbinfile file;

   EnlargeSendBuf(msglen);
   MsgLogOnAccepted *outmsg = (MsgLogOnAccepted *)SendBuffer;

   Players.resize(num+1);
   Players[num] = new myPlayer;
   Players[num]->ID   = ID;
   Players[num]->Name = (char *)(inmsg+1);
   printf("Player %s logged on.\n", Players[num]->Name.c_str());

   ZeroMemory(outmsg, sizeof(MsgLogOnAccepted));
   outmsg->Type = MT_LOGONACCEPTED;
   outmsg->ID = 0;
   outmsg->numItems = 1;
   DWORD *id = (DWORD *)(outmsg+1);
   *id++ = 1024;
   id[0] = 320, id[1] = 240, id[2] = 0;
   id+=3;
   file.open(id, msglen, file.openrw);
   item.ObjectIndex = Entities::OT_SWORD;
   item.Save(&file);

   MLO_PlayerList *plist = (MLO_PlayerList *) ((char *)id + file.tell());
   ZeroMemory(plist, sizeof(MLO_PlayerList));
   plist->numPlayers = 1;
   MPL_OnePlayer *plyr = (MPL_OnePlayer *)(plist+1);
   ZeroMemory(plyr, sizeof(MPL_OnePlayer));
   plyr->X = plyr->Y = 50, plyr->Z;
   plyr->ObjectIndex = Entities::OT_PLAYER;
   plyr->NameLen = strlen((char *)(inmsg+1))+1;
   strcpy((char *)(plyr+1), (char *)(inmsg+1));

   SendMessage(ID, outmsg, msglen, true);

   MsgCreateObject *mco = (MsgCreateObject *)SendBuffer;
   msglen = sizeof(MsgCreateObject) + sizeof(item);
   mco->Type = MT_CREATEOBJECT;
   mco->ID = 1025;
   mco->X  = mco->Y = 400;
   file.open(mco+1, msglen, file.openrw);
   item.Save(&file);

   SendMessage(ID, mco, msglen, true);

   MsgAddPlayer *map = (MsgAddPlayer *)SendBuffer;
   msglen = sizeof(MsgAddPlayer) + sizeof(MPL_OnePlayer) + 20;
   map->Type = MT_ADDPLAYER;
   plyr = (MPL_OnePlayer *)(map+1);
   plyr->ObjectIndex = Entities::OT_PLAYER;
   plyr->NameLen = 5;
   plyr->X = 500, plyr->Y = 100;
   strcpy((char *)(plyr+1), "John");
   SendMessage(ID, map, msglen, true);
} /* ProcessLogOn */


void SetRandomPos()
{
   if (Players.size() == 0) return;
   DWORD msglen = sizeof(MsgUpdatePlayers) + sizeof(MUP_OnePlayer);
   EnlargeSendBuf(msglen);
   MsgUpdatePlayers *mups = (MsgUpdatePlayers *)SendBuffer;
   MUP_OnePlayer *mup = (MUP_OnePlayer *)(mups+1);
   mups->Type = MT_UPDATEPLAYERS;
   mups->numPlayers = 1;
   mup->ID = 0;
   mup->pX = rand() % 640, mup->pY = rand() % 480, mup->Direction = rand() % 256;
   SendMessage(Players[0]->ID, mups, msglen, true);
} /* SetRandomPos */


void ProcessLogOff(DWORD ID)
{
   int i, num, pos = FindPlayer(ID);
   if (pos == -1) return;

   printf("Player %s logged off.\n", Players[pos]->Name.c_str());

   BDP.GetDP()->DestroyPlayer(Players[pos]->ID);
   delete Players[pos];
   num =  Players.size() - 1;

   for(i=0;i<num;i++) Players[i] = Players[i+1];
   Players.resize(num);
} /* ProcessLogOff */


void ProcessPickup(DWORD ID)
{
   Entities::Item item;
   MsgPickup *inmsg = (MsgPickup *)RecvBuffer;
   DWORD msglen = sizeof(MsgUpdateInv) + sizeof(item) + 15;
   EnlargeSendBuf(msglen);
   MsgUpdateInv *outmsg = (MsgUpdateInv *)SendBuffer;
   mbinfile file;

   DWORD *IDs = (DWORD *)(outmsg+1);

   outmsg->Type = MT_UPDATEINV;
   outmsg->numRems = 0;
   outmsg->numAdds = 3;
   *IDs++ = 1024;
   *IDs++ = 1026;
   file.open(IDs, sizeof(item)+5, file.openrw);
   item.ObjectIndex = Entities::OT_SWORD;
   item.Save(&file);
   IDs = (DWORD *)((char *)IDs + file.tell());
   *IDs = 1025;
   SendMessage(ID, outmsg, msglen, true);

   MsgRemPlayer *mrp = (MsgRemPlayer *)SendBuffer;
   msglen = sizeof(MsgRemPlayer);
   mrp->Type = MT_REMPLAYER;
   mrp->ID = 1;
   SendMessage(ID, mrp, msglen, true);
} /* ProcessPickup */


int HandleMessages()
{
   static Time=1000;
   DWORD NumMsgs;
   DWORD SizeNeeded = RecvBufLen;
   DWORD SenderID, RecvID;
   HRESULT hRet;

   if (BDP.GetDP()->GetMessageCount(NetID, &NumMsgs)) return 1;

   if(GetTickCount() > Time)
   {
      SetRandomPos();
      Time = GetTickCount() + 1000;
   }
   while(NumMsgs--)
   {
      hRet = BDP.GetDP()->Receive(&SenderID, &RecvID, 0, RecvBuffer, &SizeNeeded);
      if (FAILED(hRet))
      {
         if (hRet == DPERR_BUFFERTOOSMALL)
         {
            EnlargeRecvBuf(SizeNeeded);
            if (FAILED(BDP.GetDP()->Receive(&SenderID, &RecvID, 0, RecvBuffer, &SizeNeeded))) return 1;
         }
         else return 1;
      }

      if(SenderID == DPID_SYSMSG)
      {
         DPMSG_GENERIC *msg = (DPMSG_GENERIC *)RecvBuffer;
         switch(msg->dwType)
         {
            case DPSYS_DESTROYPLAYERORGROUP:
               {
                  DPMSG_DESTROYPLAYERORGROUP *msg = (DPMSG_DESTROYPLAYERORGROUP *)RecvBuffer;
                  if (msg->dwPlayerType == DPPLAYERTYPE_PLAYER) ProcessLogOff(msg->dpId);
               }
               break;
         }
      }
      else
      {
         GenericMessage *msg = (GenericMessage *)RecvBuffer;
         switch(msg->Type)
         {
            case MT_LOGON:
               ProcessLogOn(SenderID);
               break;

            case MT_LOGOFF:
               ProcessLogOff(SenderID);
               break;

            case MT_PICKUP:
               ProcessPickup(SenderID);
               break;
         }
      }
   }
   return 0;
} /* HandleMessages */
