#include <windows.h>
#include <assert.h>
#include <dplay.h>
#include <stdlib.h>
#include <time.h>
#include "Debug.h"
#include "Server.h"
#include "Network.h"
#include "Entities\Entity.h"
#include "Entities\Player.h"
#include "Network\NetMsgs.h"
#include "IntrFace\BasicDP.h"

enum EventType { ET_MESSAGE, ET_KILL, ET_TYPES };

static BasicDP BDP;

static HANDLE hThread, Events[ET_TYPES];
static CRITICAL_SECTION N_CS;
static DWORD WINAPI NetThread(LPVOID);
static DWORD NetID;
static DWORD RecvBufLen;
char        *RecvBuffer;

int InitNetwork()
{
   if (!hThread)
   {
      int conn;

      if (RecvBufLen < 512) RecvBuffer = (char *)realloc(RecvBuffer, RecvBufLen = 512);

      BDP.DeinitDP();
      if (BDP.InitDP() != BDP_NOERROR) return 1;
   
      conn = BDP.FindGUID(DPSPGUID_TCPIP);
      if (conn == -1) return 2;
      if (BDP.InitConn(conn) != BDP_NOERROR) return 3;

      SECURITY_ATTRIBUTES sa;
      DWORD id;

      sa.nLength = sizeof(SECURITY_ATTRIBUTES);
      sa.lpSecurityDescriptor = NULL;
      sa.bInheritHandle = FALSE;

      for(int i=0;i<ET_TYPES;i++) Events[i] = CreateEvent(0, 0, 0, 0);
      hThread = CreateThread(&sa, 0, NetThread, NULL, 0, &id);
      if (!hThread) return 10;
      InitializeCriticalSection(&N_CS);
   }
   return 0;
} /* InitNetwork */
      

void DeinitNetwork()
{
   if (hThread)
   {
      EndSession();
      BDP.DeinitDP();
      SetEvent(Events[ET_KILL]);
      WaitForSingleObject(hThread, INFINITE);
      for(int i=0;i<ET_TYPES;i++) CloseHandle(Events[i]);
      CloseHandle(hThread);
      hThread = 0;
      DeleteCriticalSection(&N_CS);
   }
   
} /* DeinitNetwork */


int HostSession(char *sessname)
{
   assert(hThread);

   DPSESSIONDESC2 desc;
   LPDIRECTPLAY4A pDP;

   GUID AppGUID = { 0x85409482, 0x0623, 0x4626,
                   { 0x26, 0x94, 0x89, 0x36, 0x54, 0x85, 0x94, 0x83 } };

   ZeroMemory(&desc, sizeof(desc));
   desc.dwSize  = sizeof(desc);
   desc.dwFlags = DPSESSION_CLIENTSERVER | DPSESSION_DIRECTPLAYPROTOCOL |
                  DPSESSION_KEEPALIVE | DPSESSION_OPTIMIZELATENCY;
   desc.guidApplication  = AppGUID;
   desc.dwMaxPlayers     = 1024;
   desc.lpszSessionNameA = sessname;
   
   if (FAILED(BDP.HostSession(&desc))) return 2;
   pDP = BDP.GetDP();
   assert(pDP);

   if (FAILED(pDP->CreatePlayer(&NetID, NULL, Events[ET_MESSAGE],
                                         NULL, NULL, DPPLAYER_SERVERPLAYER)))
   {
      pDP->Close();
      return 3;
   }
   
   return SessionStarted(&BDP);
} /* HostSession */


void EndSession()
{
   SessionEnding();
   BDP.GetDP()->Close();
} /* EndSession */


int SendMessage(DWORD idTo, void *msg, DWORD msglen, bool guar)
{
   assert(hThread);

   DWORD flags = DPSEND_ASYNC;
   if (guar) flags |= DPSEND_GUARANTEED;

   return BDP.GetDP()->SendEx(NetID, idTo, flags, msg, msglen, 0, 0, NULL, NULL);
} /* SendMessage */


DWORD WINAPI NetThread(LPVOID dummy)
{
   LPDIRECTPLAY4A pDP = BDP.GetDP();
   HRESULT  hRet;
   DWORD    SizeNeeded;
   DWORD    RecvID, SenderID;
   DWORD    event;

   srand(time(NULL));

   while(true)
   {
      event = WaitForMultipleObjects(ET_TYPES, Events, FALSE, INFINITE);

      if (event == WAIT_OBJECT_0 + ET_MESSAGE)
      {
         DWORD NumMsgs;
         SizeNeeded = RecvBufLen;
         hRet = pDP->GetMessageCount(NetID, &NumMsgs);
         if (FAILED(hRet))
         {
            DebugOut("NetThread: Error getting message count!\n");
            break;
         }
         while(NumMsgs--)
         {
            hRet = pDP->Receive(&SenderID, &RecvID, 0, RecvBuffer, &SizeNeeded);
            if(hRet == DPERR_BUFFERTOOSMALL) // resize buffer until it's big enough
            {
               RecvBuffer = (char *)realloc(RecvBuffer, RecvBufLen=SizeNeeded);
               hRet = pDP->Receive(&SenderID, &RecvID, 0, RecvBuffer, &SizeNeeded);
            }
            if (FAILED(hRet)) continue;         // error: skip this message
            HandleMessage(SenderID);
         }
      }
      else if (event == WAIT_OBJECT_0 + ET_KILL)
      {
         ExitThread(0);
         return 0;
      }
   }

   return 0;
}