#include <windows.h>
#include <assert.h>
#include <vector>
#include <string>
#include "Players.h"
#include "Items.h"
#include "Math\Random.h"
#include "Entities\Item.h"
#include "Entities\Player.h"
#include "Vectors\Vector.h"
#include "Network\NetMsgs.h"


std::vector<Entities::Player *>  Players;
int NumPlayers;

/* roll attributes for this player.. distribute 'points' points among the
   5 base attributes (str, int, dex, spd, hits) with on average basechances[i]/2
   points going to each of the 5 until points is used up */
static void InitStats(Entities::Player *, int points, int baseattrs[5], int basechances[5]);

DWORD AddPlayer(char *name, DWORD netID)
{
   Entities::Player *player = new Entities::Player;
   player->Name   = name;
   player->NetID  = netID;
   
   int bases[5] = {4,2,3,2,10}, chances[5] = { 10, 5, 8, 6, 15 };
   InitStats(player, 35, bases, chances);

   int num = Players.size(), last = NumPlayers++;
   if (Players.size() == last) Players.resize(last + 10, NULL);
   Players[last] = player;
   return last;
} /* AddPlayer */


void RemPlayer(DWORD id)
{
   int num = --NumPlayers;
   assert(id <= num);
      
   delete Players[id];
   Players[id]  = Players[num];
   Players[num] = NULL;
} /* RemPlayer */
   

void ClearPlayers()
{
   int i, num = NumPlayers;
   for(i=0;i<num;i++) delete Players[i];
   Players.resize(0);
   NumPlayers = 0;
} /* ClearPlayers */


int FindPlayer(DWORD NetID)
{
   for(int i=0;i<NumPlayers;i++) if(Players[i]->NetID == NetID) return i;
   return -1;
} /* FindPlayer */


void InitStats(Entities::Player *player, int points, int baseattrs[5], int basechances[5])
{
   Math::Random rnd;
   int i, sum;
   
   while(points > 0)
   {
      sum = 0;
      for(i=0;i<5;i++)
      {
         int num = rnd.RandPeak(0, basechances[i]);
         sum += num;
         baseattrs[i] += num;
      }
      points -= sum;
   }
   while(points < 0) baseattrs[rnd.Rand(0, 4)]--, points++;
   
   player->SetStr (baseattrs[0], Entities::Player::ST_ABSOLUTE);
   player->SetInt (baseattrs[1], Entities::Player::ST_ABSOLUTE);
   player->SetDex (baseattrs[2], Entities::Player::ST_ABSOLUTE);
   player->SetDef (baseattrs[3], Entities::Player::ST_ABSOLUTE);
   player->SetHits(baseattrs[4], Entities::Player::ST_ABSOLUTE);
   player->CurHits   = player->MaxHits;
   player->Weight    = 0;
   player->Direction = 0;
   player->Accel     = Vectors::Vector<int>(0, 0, 0);
} /* RandomStats */
