#include <windows.h>
#include <stdarg.h>
#include <stdio.h>
#include <list>
#include "PrintQueue.h"

enum EventType { ET_MESSAGE, ET_KILL, ET_TYPES };

static std::list<char *> Messages;
static HANDLE hThread, Events[ET_TYPES];
static CRITICAL_SECTION PQ_CS;
static volatile bool Running;

static DWORD WINAPI PrintQueue(LPVOID);


int InitPrintQueue()
{
   if (!hThread)
   {
      SECURITY_ATTRIBUTES sa;
      DWORD id;

      sa.nLength = sizeof(SECURITY_ATTRIBUTES);
      sa.lpSecurityDescriptor = NULL;
      sa.bInheritHandle = FALSE;

      for(int i=0;i<ET_TYPES;i++) Events[i] = CreateEvent(0, 0, 0, 0);
      hThread = CreateThread(&sa, 0, PrintQueue, NULL, 0, &id);
      if (!hThread) return 1;
      InitializeCriticalSection(&PQ_CS);
      Running = true;
   }
   return 0;
} /* InitPrintQueue */
      

void DeinitPrintQueue()
{
   if (hThread)
   {
      SetEvent(Events[ET_KILL]);
      WaitForSingleObject(hThread, INFINITE);
      for(int i=0;i<ET_TYPES;i++) CloseHandle(Events[i]);
      CloseHandle(hThread);
      hThread = 0;
      DeleteCriticalSection(&PQ_CS);
   }
} /* DeinitPrintQueue */


int QueueMessage(const char *str)
{
   int len;
   char *msg = new char[len = strlen(str)+1];
   CopyMemory(msg, str, len);

   EnterCriticalSection(&PQ_CS);
   Messages.push_back(msg);
   SetEvent(Events[ET_MESSAGE]);
   LeaveCriticalSection(&PQ_CS);
   return 0;
} /* QueueMessage(const char *str) */


int QueueMessageF(const char *str, ...)
{
   if (!hThread) return 1;

   char buf[1024];
   va_list list;

   va_start(list, str);
   vsprintf(buf, str, list);
   va_end(list);

   return QueueMessage(buf);
} /* QueueMessage(const char *str, ...) */


void StopPrintQueue()
{
   EnterCriticalSection(&PQ_CS);
   Running = false;
   LeaveCriticalSection(&PQ_CS);
} /* StopPrintQueue */


void ResumePrintQueue()
{
   EnterCriticalSection(&PQ_CS);
   Running = true;
   LeaveCriticalSection(&PQ_CS);
} /* ResumePrintQueue */


DWORD WINAPI PrintQueue(LPVOID dummy)
{
   DWORD event;
   bool  msgwaiting;

   while(true)
   {
      event = WaitForMultipleObjects(ET_TYPES, Events, FALSE, msgwaiting ? 150 : INFINITE);

      switch(event)
      {
         case WAIT_TIMEOUT:   // must be a message waiting
            if (!Running) break;
            // else fall through

         case WAIT_OBJECT_0 + ET_MESSAGE:
            {
               if (Running)
               {
                  EnterCriticalSection(&PQ_CS);
                  int num = Messages.size();
                  while(num--)
                  {
                     char *msg = *Messages.begin();
                     Messages.pop_front();
                     fputs(msg, stdout);
                     delete[] msg;
                  }
                  msgwaiting = false;
                  LeaveCriticalSection(&PQ_CS);
               }
               else msgwaiting = true;
            }
            break;

         case WAIT_OBJECT_0 + ET_KILL:
            ExitThread(0);
            return 0;
      }
   }
   return 0;
} /* PrintQueue */
