#include <assert.h>
#include "Frame\Debug.h"
#include "Entity.h"

namespace Entities
{
   ObjectFactory OnlyObjectFactory;

   
   int Entity::SetObject(ObjectType ot, SetObjType sot)
   {
      switch(sot)
      {
         case SOT_MAKENEW:
            if(!(Object = OnlyObjectFactory.New(ot))) return 1;
            break;

         case SOT_USECOPY:
            if (!(Object = OnlyObjectFactory.Ptr(ot))) return 1;
            break;

         default:
            return 2;
      }

      return 0;
   }

   
   ObjectFactory::~ObjectFactory()
   {
      for(int i=0;i<OT_NUMOBJECTS;i++) delete Objs[i];
   }

   
   int ObjectFactory::Load(binfile *file)
   {
      int i, num;

      if (Initialized)
      {
         MsgBox("ObjectFactory Already Initialized!");
         return 1;
      }

      file->read(&num, sizeof(num));
      if (OT_NUMOBJECTS != num) return 1;

      for(i=0;i<num;i++)
      {
         Objs[i] = new Vectors::VectObject();
         Objs[i]->Load(file);
      }
      Initialized = TRUE;
      return 0;
   }

   
   Vectors::VectObject * ObjectFactory::New(ObjectType ot)
   {
      if (!Initialized)
      {
         if (!BeQuiet) MsgBox(ErrNotInit);
         return NULL;
      }
      assert(ot >= 0 && ot < OT_NUMOBJECTS);
      return new Vectors::VectObject(*Objs[ot]);
   }

   
   Vectors::VectObject * ObjectFactory::Ptr(ObjectType ot)
   {
      if (!Initialized)
      {
         if (!BeQuiet) MsgBox(ErrNotInit);
         return NULL;
      }
      assert(ot >= 0 && ot < OT_NUMOBJECTS);
      return Objs[ot];
   }
}
