#ifndef _ENTITY_H
#define _ENTITY_H

#include <string>
#include "IntrFace\CDDraw.h"
#include "Binfile\Binfile.h"
#include "Graphics\PrimDraw.h"
#include "Vectors\Vector.h"
#include "Vectors\VectObject.h"

namespace Entities
{
   enum ObjectType { OT_PLAYER, OT_NUMOBJECTS, OT_FORCEDWORD=0xFFFFFFFF };

   class ObjectFactory;

   class Entity
   {
      public:
         Vectors::Vector<int> Position;
         std::string          Name;

         Entity() : myAngle(0), Object(NULL) { };
         enum SetObjType { SOT_MAKENEW, SOT_USECOPY };
         int  SetObject(ObjectType ot, SetObjType sot);

         int Draw(Graphics::PrimDraw *pd, CDDSurface *dest, int xc, int yc)
         {
            return Object->Draw(pd, dest, xc, yc, 0, 0);
         }
         int Erase(Graphics::PrimDraw *pd, CDDSurface *dest, int xc, int yc, CDDColor c)
         {
            return Object->Draw(pd, dest, xc, yc, Object->VO_COLOROVERRIDE, c);
         }
         std::string const &GetName()
         {
            return Name;
         }
         void SetName(std::string const name)
         {
            Name = name;
         }
         void SetPos(int x, int y, int z)
         {
            Position = Vectors::Vector<int>(x,y,z);
         }
         void RotateObject(int angle)
         {
            if (angle == myAngle) return;
            Object->Rotate(myAngle = angle);
         }

      protected:
         Vectors::VectObject *Object;
         DWORD                myAngle;
   };


   class ObjectFactory
   {
      public:
         ObjectFactory()
            : Initialized(FALSE), ErrNotInit("ObjectFactory used but not initialized.") { };
         ~ObjectFactory();

         int Load(binfile *file);
         
         // make it be quiet (ie, we dont care if it's not initialized!)
         void Hush(bool quiet)
         {
            BeQuiet = quiet;
         }

         Vectors::VectObject * New(ObjectType ot);    // returns a new instance of an object
         Vectors::VectObject * Ptr(ObjectType ot);    // returns a ptr to a single instance of an object

      private:
         Vectors::VectObject *Objs[OT_NUMOBJECTS];
         bool                 Initialized, BeQuiet;
         char                *ErrNotInit;
   };

   extern ObjectFactory OnlyObjectFactory;
}

#endif