#include <assert.h>
#include "Math\Random.h"
#include "Frame\Debug.h"
#include "Item.h"

namespace Entities
{
   ItemFactory OnlyItemFactory;
      
   int Item::Load(binfile *file)
   {
      int ret = 0;
      ret += file->read(&Flags,     sizeof(Flags));
      ret += file->read(&StrBonus,  sizeof(StrBonus));
      ret += file->read(&IntBonus,  sizeof(IntBonus));
      ret += file->read(&DexBonus,  sizeof(DexBonus));
      ret += file->read(&SpdBonus,  sizeof(SpdBonus));
      ret += file->read(&DefBonus,  sizeof(DefBonus));
      ret += file->read(&HitsBonus, sizeof(HitsBonus));
      ret += file->read(&AttkBonus, sizeof(AttkBonus));
      ret += file->read(&Weight,    sizeof(Weight));
      ret += file->read(&myType,    sizeof(myType));
      ret += file->read(&Place,     sizeof(Place));
      ret += file->read(&ObjectIndex, sizeof(ObjectIndex));
      SetObject(ObjectIndex);
      return ret;
   } /* Load */


   int Item::Save(binfile *file)
   {
      int ret = 0;
      ret += file->write(&Flags,     sizeof(Flags));
      ret += file->write(&StrBonus,  sizeof(StrBonus));
      ret += file->write(&IntBonus,  sizeof(IntBonus));
      ret += file->write(&DexBonus,  sizeof(DexBonus));
      ret += file->write(&SpdBonus,  sizeof(SpdBonus));
      ret += file->write(&DefBonus,  sizeof(DefBonus));
      ret += file->write(&HitsBonus, sizeof(HitsBonus));
      ret += file->write(&AttkBonus, sizeof(AttkBonus));
      ret += file->write(&Weight,    sizeof(Weight));
      ret += file->write(&myType,    sizeof(myType));
      ret += file->write(&Place,     sizeof(Place));
      ret += file->write(&ObjectIndex, sizeof(ObjectIndex));
      return ret;
   } /* Save */

   
   ItemFactory::ItemFactory() : Initialized(false)
   {
      for(int i=0;i<IC_ANY;i++) Sizes[i] = 0;
   } /* Constructor */


   ItemFactory::~ItemFactory()
   {
      delete[] StatList;
   } /* Destructor */


   int ItemFactory::Load(binfile *file)
   {
      int i, num;

      if (Initialized)
      {
         MsgBox("ItemFactory already initialized!");
         return 1;
      }

      file->read(&num, sizeof(num));
      NumStats = num;
      StatList = new Stats[num];

      for(i=0;i<num;i++)
      {
         StatList[i].Load(file);
         Sizes[StatList[i].Type]++;
      }

      Initialized = true;
      return 0;
   } /* Load */


   void ItemFactory::Stats::Load(binfile *file)
   {
      file->read(&Type,   sizeof(int));
      file->read(&Object, sizeof(int));
      file->read(&Place,  sizeof(int));
      file->read(&Cursed, sizeof(int));
      file->read(&Weight, sizeof(int));
      for(int i=0;i<NUMATTRS;i++)
      {
         file->read(&Min[i], sizeof(int));
         file->read(&Max[i], sizeof(int));
         file->read(&Avg[i], sizeof(int));
      }
      int len;
      file->read(&len, sizeof(int));
      char *buf = new char[len];
      file->read(buf, len);
      Name = buf;
      delete[] buf;
   } /* Stats::Load */

   
   Item * ItemFactory::NewItem(ItemType it)
   {
      Math::Random rnd;
      Stats *stat = &StatList[it];
      Item  *item = new Item;

      item->Flags.Cursed = (rnd.Rand(99) < stat->Cursed);
      item->StrBonus  =
         rnd.RandPeak(stat->Min[stat->STR], stat->Avg[stat->STR], stat->Max[stat->STR]);
      item->IntBonus  =
         rnd.RandPeak(stat->Min[stat->INT], stat->Avg[stat->INT], stat->Max[stat->INT]);
      item->DexBonus  =
         rnd.RandPeak(stat->Min[stat->DEX], stat->Avg[stat->DEX], stat->Max[stat->DEX]);
      item->SpdBonus  =
         rnd.RandPeak(stat->Min[stat->SPD], stat->Avg[stat->SPD], stat->Max[stat->SPD]);
      item->DefBonus  =
         rnd.RandPeak(stat->Min[stat->DEF], stat->Avg[stat->DEF], stat->Max[stat->DEF]);
      item->AttkBonus =
         rnd.RandPeak(stat->Min[stat->ATTK], stat->Avg[stat->ATTK], stat->Max[stat->ATTK]);
      item->HitsBonus =
         rnd.RandPeak(stat->Min[stat->MAXHITS], stat->Avg[stat->MAXHITS], stat->Max[stat->MAXHITS]);
      item->SetObject(stat->Object);
      item->Name   = stat->Name;
      item->Place  = stat->Place;
      item->Weight = stat->Weight;
      item->myType = stat->Type;

      return item;
   } /* NewItem */


   Item * ItemFactory::RandomItem(ItemType itemclass)
   {
      Math::Random rnd;
      int i, num = NumStats, index;

      if (itemclass == IC_ANY) itemclass = (ItemType)rnd.Rand(IC_ANY-1);
      if (!Sizes[itemclass]) return NULL;
      index = rnd.Rand(Sizes[itemclass]-1);

      for(i=0;i<num;i++)
      {
         if(StatList[i].Type == itemclass && !index--) break;
      }
      return NewItem((ItemType)i);
   } /* RandomItem */
}
