#ifndef _ITEM_H
#define _ITEM_H

#include <windows.h>
#include "Entity.h"
#include "EntityShared.h"

namespace Entities
{
   enum ItemType
   {
      // item classes
      IC_WEAPON=0, IC_SCROLL, IC_POTION, IC_ARMOR, IC_ANY,

      // Specific item types to pass to NewItem
      // WEAPON TYPES
      IT_WEAP_HALLY=0,
      // SCROLL TYPES
      IT_SCR_LIGHT,
      // POTION TYPES
      IT_POT_SUCKNESS,
      // ARMOR TYPES
      IT_ARM_REDBODY,
      // Forces enum to at least 32-bits
      IT_FORCEDWORD=0xFFFFFFFF
   };

   class Item : public Entity
   {
      public:
         DWORD ID;         
         
         struct sFlags
         {
            unsigned Cursed : 1;
         } Flags;

         int      StrBonus, IntBonus, DexBonus, SpdBonus, DefBonus, HitsBonus, AttkBonus;
         int        Weight;
         ItemType   myType;
         EquipPlace Place;

         ObjectType ObjectIndex;

         bool CanEquip(EquipPlace ep)
         {
            return ep == Place;
         }
         ItemType Type()
         {
            return myType;
         }
         int SetObject(ObjectType ot)
         {
            ObjectIndex = ot;
            return Entity::SetObject(ot, SOT_USECOPY);
         };

         // both return # of bytes read/written or 0 on error
         int Load(binfile *file);
         int Save(binfile *file);
   };

   class ItemFactory
   {
      public:
         ItemFactory();
         ~ItemFactory();
         int Load(binfile *);
         Item * NewItem(ItemType it);
         Item * RandomItem(ItemType itemclass);

      private:
         struct Stats
         {
            enum { STR, INT, DEX, SPD, DEF, ATTK, MAXHITS, NUMATTRS };
            int Min[NUMATTRS], Max[NUMATTRS], Avg[NUMATTRS];
            int Cursed, Weight;
            ItemType    Type;
            ObjectType  Object;
            EquipPlace  Place;
            std::string Name;
            void Load(binfile *file);
         };
         Stats *StatList;
         int    NumStats;
         int    Sizes[IC_ANY];
         bool   Initialized;
   };

   extern ItemFactory OnlyItemFactory;
}

#endif
