#include <assert.h>
#include "Player.h"

namespace Entities
{
   Player::Player()
   {
      ZeroMemory(&Flags, sizeof(Flags));
      ZeroMemory(Equipped, sizeof(Item *) * EP_EQUIPPLACES);
      Str = Int = Dex = Spd = Def = Attk = CurHits = MaxHits =
         Weight = MaxWeight = Direction = 0;
   } /* Constructor */


   Player::~Player()
   {
      if(Object) delete Object;
   } /* Destructor */


   int Player::SetStr(int str, SetType st)
   {
      int oldstr = Str;

      if (st == ST_ABSOLUTE) Str = str;
      else Str += str;

      MaxWeight = Str * 100;
      Flags.Burdened = Weight > MaxWeight ? 1 : 0;

      SetAttk(Str - oldstr, ST_RELATIVE);
      return Str;
   } /* SetStr */


   int Player::SetInt(int nint, SetType st)
   {
      int oldint = Int;

      if (st == ST_ABSOLUTE) Int = nint;
      else Int += nint;

      return Int;
   } /* SetInt */


   int Player::SetDex(int dex, SetType st)
   {
      int olddex = Dex;

      if (st == ST_ABSOLUTE) Dex = dex;
      else Dex += dex;

      SetSpd(Dex - olddex, ST_RELATIVE);
      SetDef(Dex - olddex, ST_RELATIVE);
      return Dex;
   } /* SetDex */


   int Player::SetSpd(int spd, SetType st)
   {
      int oldspd = Spd;

      if (st == ST_ABSOLUTE) Spd = spd;
      else Spd += spd;

      return Spd;
   } /* SetSpd */


   int Player::SetDef(int def, SetType st)
   {
      int olddef = Def;

      if (st == ST_ABSOLUTE) Def = def;
      else Def += def;

      return Def;
   } /* SetDef */


   int Player::SetAttk(int attk, SetType st)
   {
      int oldattk = Attk;

      if (st == ST_ABSOLUTE) Attk = attk;
      else Attk += attk;

      return Attk;
   } /* SetAttk */


   int Player::SetHits(int hits, SetType st)
   {
      int oldhits = MaxHits;

      if (st == ST_ABSOLUTE) MaxHits = hits;
      else MaxHits += hits;

      return MaxHits;
   } /* SetHits */


   Player::EquipError Player::Equip(Item *item, EquipPlace ep)
   {
      int pos = FindItem(item);

      if (pos == -1) return EE_DONTHAVE;
      if (!item->CanEquip(ep)) return EE_CANTEQUIP;
      if (Equipped[ep] == NULL) return EE_ALREADYEQUIPPED;

      Equipped[ep] = Inv[pos];
      return EE_OK;
   } /* Equip */


   void Player::DeEquip(Item *item)
   {
      for(int i=0;i<EP_EQUIPPLACES;i++) if(Equipped[i] == item) Equipped[i] = NULL;
   } /* DeEquip(Item *) */


   void Player::PickUp(Item *item)
   {
      int pos = FindItem(NULL);
      if (pos == -1)
      {
         pos = Inv.size();
         Inv.resize(pos + 10, NULL);
      }
      Inv[pos] = item;
   } /* PickUp */


   int Player::Drop(Item *item)
   {
      int pos = FindItem(item);
      assert(pos != -1);
      DeEquip(item);
      
      item->Position = Position;
      Inv[pos] = NULL;
      return 0;
   } /* Drop */


   int Player::FindItem(Item *item)
   {
      int i, num=Inv.size();
      for(i=0;i<num;i++) if (Inv[i] == item) return i;
      return -1;
   } /* FindItem */
}