#ifndef _PLAYER_H
#define _PLAYER_H

#include <windows.h>
#include <vector>
#include "Entity.h"
#include "EntityShared.h"
#include "Vectors\Vector.h"
#include "Item.h"

namespace Entities
{
   class Player : public Entity
   {
      public:
         Player();
         ~Player();

         // Base Attributes
         int Str, Int, Dex, Spd, Def, Attk, MaxHits;
         // Derived or variable attributes
         int CurHits;
         int Weight, MaxWeight;
         int Direction;

         DWORD NetID;

         struct pFlags
         {
            unsigned Burdened : 1;
         } Flags;

         Vectors::Vector<int> Accel;
         std::vector<Item *>  Inv;
         Item *               Equipped[EP_EQUIPPLACES];

         enum SetType { ST_ABSOLUTE, ST_RELATIVE };
         // Use these to be sure that the secondary attributes are updated
         int SetStr(int, SetType);
         int SetInt(int, SetType);
         int SetDex(int, SetType);
         int SetSpd(int, SetType);
         int SetDef(int, SetType);
         int SetAttk(int, SetType);
         int SetHits(int, SetType);

         int SetObject(ObjectType ot)
         {
            return Entity::SetObject(ot, SOT_MAKENEW);
         };
         void SetAccel(int x, int y, int z)
         {
            Accel = Vectors::Vector<int>(x,y,z);
         }

         enum EquipError { EE_OK, EE_CANTEQUIP, EE_ALREADYEQUIPPED, EE_DONTHAVE };
         EquipError Equip(Item *, EquipPlace);
         void DeEquip(EquipPlace ep)
         {
            Equipped[ep] = NULL;
         } /* DeEquip(EquipPlace) */

         void PickUp(Item *);
         int  Drop(Item *);

      private:
         int  FindItem(Item *item);
         void DeEquip(Item *);
   };
}

#endif
