#include <windows.h>
#include <stdarg.h>
#include <stdio.h>
#include "Defines.h"
#include "Debug.h"
#include "Externs.h"

#ifdef NDEBUG
   void MsgBox(char const *str, ...)
   {
      char buf[1024];
      va_list list;
      va_start(list, str);
      vsprintf(buf, str, list);
      va_end(list);
#ifdef NEED_GRAPHICS
      if (Cgraph.GetDD()) Cgraph.GetDD()->FlipToGDISurface();
#endif
      MessageBox(NULL, buf, "Debug", MB_OK);
   }
#else
   void MsgBox(char const *str, ...)
   {
      char buf[1024];
      va_list list;
      va_start(list, str);
      vsprintf(buf, str, list);
      va_end(list);
#ifdef NEED_GRAPHICS
      if (Cgraph.GetDD()) Cgraph.GetDD()->FlipToGDISurface();
#endif
      DebugOut(buf);
      DebugOut("\n");
      MessageBox(NULL, buf, "Debug", MB_OK);
   }

   void DebugOut(char const *str, ...)
   {
      char buf[1024];
      int i;
      va_list list;
      va_start(list, str);
      i=vsprintf(buf, str, list);
      va_end(list);
      OutputDebugString(buf);
   }
#endif

