#ifndef _DEFINES_H
#define _DEFINES_H

// define these if you need them
#define NEED_GRAPHICS
//#define NEED_SOUND      // for dsound
//#define NEED_MUSIC      // for midas
#define NEED_MOUSE
#define NEED_KEYBOARD

#define DISPLAYWIDTH    640
#define DISPLAYHEIGHT   480
#define DISPLAYDEPTH    CDD_16BIT
// use MYRGB to generate RGB values for CDDColor
#define MYRGB CDDRGB16  // for 16-bit color
//#define MYRGB CDDRGB

// define to run in windowed mode
#define WINDOWED

#define VERSION         "0.10a"
#define APPCLASS        "Ronx"
#define APPTITLE        "Ronx" " " VERSION

#if defined(NEED_MOUSE) || defined(NEED_KEYBOARD)
   #define NEED_INPUT
#endif
#if defined(NEED_MUSIC) && !defined(NEED_SOUND)
   #define NEED_SOUND
#endif
   
// number of buffers for input devices
#define INPUTBUFSIZE 16

// number of buffers allocated for sound effects
#define NUMSOUNDBUFS 16

// these queues hold a history of button presses/releases and mouse clicks in
// case the program is too busy to catch them with polling the current values
#define KEYHISTORY   32
#define CLICKHISTORY 32

// use MIDAS_MIX_NORMAL_QUALITY   for less CPU usage
#define MIDASQUALITY    MIDAS_MIX_HIGH_QUALITY
#define MIDASMIXRATE    44100
#define MIDASOUTMODE    MIDAS_MODE_16BIT_STEREO

#define SOUNDMIXRATE    MIDASMIXRATE
#define SOUNDCHANS      2
#define SOUNDBITS       16

#endif
