#ifndef _EXTERNS_H
#define _EXTERNS_H

#include <windows.h>
#include "Defines.h"

#ifdef NEED_GRAPHICS
   #include "IntrFace\CGraphic.h"
#endif

#ifdef NEED_INPUT
   #include <list>
   #include "IntrFace\CDInput.h"
#endif

#if defined(NEED_SOUND)
   #include "IntrFace\CDSound.h"
#endif

#ifdef NEED_MUSIC
   #include "IntrFace\CMidas.h"
#endif

#include "Init.h"
#include "Game.h"

// from Game.cpp
#ifdef NEED_GRAPHICS
   extern CGraphics  Cgraph;
#endif

#ifdef NEED_INPUT
   extern CDInput    Cdinput;
   #ifdef NEED_MOUSE
      extern CDIDevice  Cdmouse;
   #endif
   #ifdef NEED_KEYBOARD
      extern CDIDevice  Cdkeyboard;
   #endif
#endif
#ifdef NEED_SOUND
   extern CDSound    Cdsound;
#endif
#ifdef NEED_MUSIC
   extern CMidas     Cmidas;
#endif
extern volatile bool g_bNeedRedraw;

// from Init.cpp
extern volatile bool g_bInitDone;

#ifdef NEED_INPUT
   extern volatile bool g_bInputFailure;
#endif
#ifdef NEED_KEYBOARD
   extern byte KeyboardBuf[256];
   extern std::list<KeyPress>   KeyHistory;
#endif
#ifdef NEED_MOUSE
   extern int MouseX, MouseY, MouseBtn[4];
   extern std::list<MouseClick> ClickHistory;
#endif

// from WinApi.cpp
volatile extern bool g_bFocus;
volatile extern bool g_bQuitApp;
extern HWND          g_hWnd;
extern HINSTANCE     g_hInst;
extern char         *g_AppPath;
extern char         *g_CmdLine;

#endif

