#pragma warning ( 3 : 4706)
/********************************* Main.cpp ***********************************\
* The main program file, contains WinMain and calls all the other functions    *
* needed to make the game run.                                                 *
\******************************************************************************/


#include <windows.h>
#include "defines.h"
#include "WinApi.h"
#include "Game.h"
#include "Init.h"
#include "Debug.h"

int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrev, PSTR szCmd, int iCmdShow)
{
   HRESULT hRet;
   int     err;

   try
   {
      hRet = CoInitialize(NULL);
      if (FAILED(hRet))
      {
         MsgBox("WinMain:CoInitialize: Error %d", hRet);
         return 1;
      }
      
      err = InitAppWindow(hInst, iCmdShow, GetCommandLine());
      if (err)
      {
         MsgBox("WinMain:InitAppWindow: Error %d", err);
         return 2;
      }
      
      err = InitGame();
      if (err)
      {
         MsgBox("WinMain:InitGame: Error %d", err);
         return 3;
      }
   
      err = MainGameLoop();
      if (err)
      {
         MsgBox("WinMain:MainGameLoop: Error %d", err);
         return 4;
      }
   }
   catch(...)
   {
      DeinitGame();
      CoUninitialize();
      MessageBox(NULL, "WinMain:catch(...): Unhandled Exception.",
                 "Error!", MB_OK);
      return 10;
   }

   err = DeinitGame();
   if (err)
   {
      MsgBox("WinMain:DeinitGame: Error %d", err);
      return 5;
   }
   CoUninitialize();
   return 0;
} /* WinMain */

