#pragma warning ( 3 : 4706)
/****************************** WinApi.cpp ***********************************\
* These file deals with setting up the window, program setup and teardown,    *
* and the Window Procedure.  It defines the following globals:                *
\*****************************************************************************/


#include <windows.h>
#include "WinApi.h"
#include "defines.h"
#include "Externs.h"

/***** GLOBALS *****/
volatile bool g_bFocus;
volatile bool g_bQuitApp;
HWND        g_hWnd;
HINSTANCE   g_hInst;
char       *g_AppPath;
char       *g_CmdLine;
/*******************/


/***** STATICS *****/
static long CALLBACK WindowProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam);
/*******************/


int InitAppWindow(HINSTANCE hInst, int iCmdShow, PSTR CmdLine)
// Creates and sets up the main app window. sets g_hWnd and g_hInst
// returns 0 on success, non-zero on failure
{
   WNDCLASS    wc;
   char       *AppName  = APPCLASS;
   char       *AppTitle = APPTITLE;
   int         i;

   g_CmdLine = CmdLine;

   for(i=strlen(CmdLine);i>0;i--) if (CmdLine[i] == '\\') break;
   g_AppPath = new char[i + 1];
   CopyMemory(g_AppPath, CmdLine+1, i);
   g_AppPath[i] = 0;

   // Set up and register window class
   wc.style = CS_HREDRAW | CS_VREDRAW;
   wc.lpfnWndProc    = WindowProc;
   wc.cbClsExtra     = 0;
   wc.cbWndExtra     = 0;
   wc.hInstance      = hInst;
   wc.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor        = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground  = (HBRUSH)GetStockObject(BLACK_BRUSH);
   wc.lpszMenuName   = NULL;
   wc.lpszClassName  = AppName;
   if (!RegisterClass(&wc)) return 1;

   // Create a window
#ifdef WINDOWED
   g_hWnd = CreateWindow(AppName, AppTitle,
                         WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX,
                         0, 0, DISPLAYWIDTH+6, DISPLAYHEIGHT+25, NULL, NULL, hInst, NULL);
#else
   g_hWnd = CreateWindow(AppName, AppTitle, WS_POPUP, 0, 0,
                       GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN),
                       NULL, NULL, hInst, NULL);
#endif

   if (!g_hWnd) return 2;
   g_hInst = hInst;

#ifdef WINDOWED
   ShowWindow(g_hWnd, iCmdShow);
#else
   ShowWindow(g_hWnd, SW_SHOWMAXIMIZED);
#endif

   UpdateWindow(g_hWnd);
   SetFocus(g_hWnd);
   
   return 0;
} /* InitAppWindow */


long CALLBACK WindowProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
   switch(iMsg)
   {
      case WM_CREATE:
         g_bFocus = g_bQuitApp = FALSE;
         return 0;

      case WM_ACTIVATE:
         // Pause if deactivated
         g_bFocus = !(LOWORD(wParam) == WA_INACTIVE);
#ifdef NEED_INPUT
         if (g_bInitDone)
         {
            if (g_bFocus)
            {
#ifdef NEED_MOUSE
               Cdinput.Acquire(&Cdmouse);
#endif
#ifdef NEED_KEYBOARD
               Cdinput.Acquire(&Cdkeyboard);
#endif
            }
            else
            {
#ifdef NEED_MOUSE
               Cdinput.Unacquire(&Cdmouse);
#endif
#ifdef NEED_KEYBOARD
               Cdinput.Unacquire(&Cdkeyboard);
#endif
            }
         }
#endif
         return 0;
      
      case WM_SIZE:
      case WM_MOVE:
      #ifdef WINDOWED
         Cgraph.UpdateWindowed();
         g_bNeedRedraw = TRUE;
      #endif
         return 0;

      case WM_PAINT:
         g_bNeedRedraw = TRUE;
         break;

      case WM_MOUSEMOVE:
         ShowCursor(FALSE);
         return 0;

      case WM_DESTROY:
         g_bQuitApp = TRUE;
         PostQuitMessage(0);
         return 0;
   }

   return DefWindowProc(hWnd, iMsg, wParam, lParam);
} /* WindowProc */

