#include <windows.h>
#include "PrimDraw.h"
#include "Frame\Defines.h"
#include "Frame\Debug.h"

#pragma message("*** Optimize PrimDraw")

namespace Graphics
{
   void PrimDraw::SetCDDraw(CDDraw *cd)
   {
      CD = cd;
   }


   void PrimDraw::Plot(CDDSurface *dest, int x, int y, CDDColor c)
   {
      if (x < 0 || y < 0 || x >= dest->Width || y >= dest->Height) return;
      *(WORD*)(dest->Mem + dest->Pitch * y + x*2) = c.c16;
   } /* Plot */

            
   int PrimDraw::Point(CDDSurface *dest, int x, int y, CDDColor c)
   {
      int Locked = dest->Stats.fLocked;
      CDDErrors ret;

      if (!Locked)
      {
         ret = CD->Lock(dest);
         if (ret != CDD_NOERROR)
         {
            HRESULT hRet = CD->GetLastDDError();
            if (hRet == DDERR_SURFACELOST)
            {
               if (CD->RestoreAll() != CDD_NOERROR) return 2;
               if (CD->Lock(dest)   != CDD_NOERROR) return 3;
            }
            else return 1;
         }
      }

      Plot(dest, x, y, c);

      if (!Locked) CD->Unlock(dest);
      return 0;
   } /* Point */


   int PrimDraw::Line(CDDSurface *dest, int x1, int y1, int x2, int y2,
                      CDDColor c)
   {
      unsigned char *Mem;
      int Pitch;
      int Locked = dest->Stats.fLocked;
      WORD pixel = c.c16;
      int xi;
      int dx,dy,ai,bi;
      int d;
      CDDErrors ret;

      if(x1>x2)
      {  int t;
         t=x1, x1=x2, x2=t;
         t=y1, y1=y2, y2=t;
      }

      if(x1>=dest->Width || x2<0) return 0;
      if(x1<0)
      {  if(x2==x1) return 0;
         y1+=-x1*(y2-y1)/(x2-x1);
         x1=0;
      }
      if(x2>=dest->Width)
      {  if(x2==x1) return 0;
         y2-=(x2-dest->Width)*(y2-y1)/(x2-x1);
         x2=dest->Width-1;
      }

      if(y1>y2)
      {  int t;
         t=x1, x1=x2, x2=t;
         t=y1, y1=y2, y2=t;
      }

      if(y1>=dest->Height || y2<0) return 0;
      if(y1<0)
      {  if(y1==y2) return 0;
         x1+=-y1*(x2-x1)/(y2-y1);
         y1=0;
      }
      if(y2>=dest->Height)
      {  if(y1==y2) return 0;
         x2-=(y2-dest->Height)*(x2-x1)/(y2-y1);
         y2=dest->Height-1;
      }

      if (!Locked)
      {
         ret = CD->Lock(dest);
         if (ret != CDD_NOERROR)
         {
            HRESULT hRet = CD->GetLastDDError();
            if (hRet == DDERR_SURFACELOST)
            {
               if (CD->RestoreAll() != CDD_NOERROR) return 2;
               if (CD->Lock(dest)   != CDD_NOERROR) return 3;
            }
            else return 1;
         }
      }

      Pitch = dest->Pitch;
      Mem   = dest->Mem + Pitch*y1 + x1*2;
      
      if (x1<x2)
      {
         xi=2;
         dx=x2-x1;
      }
      else
      {
         xi=-2;
         dx=x1-x2;
      }
   
      dy=y2-y1;
   
      *(WORD*)Mem = pixel;

      if (dx>dy)
      {
         ai=(dy-dx)<<1;
         bi=dy<<1;
         d=bi-dx;
         for(int i=0;i<dx;i++)
         {
            if(d>=0)
            {
               Mem += Pitch;
               d+=ai;
            }
            else d += bi;
            Mem += xi;
            *(WORD *)Mem = pixel;
         }
      }
      else
      {
         ai=(dx-dy)<<1;
         bi=dx<<1;
         d=bi-dy;
         for(int i=0;i<dy;i++)
         {
            if(d>=0)
            {
               Mem += xi;
               d += ai;
            }
            else d += bi;
            Mem += Pitch;
            *(WORD *)Mem = pixel;
         }
      }

      if (!Locked) CD->Unlock(dest);

      return 0;
   } /* Line */


   int PrimDraw::Circle(CDDSurface *dest, int x, int y, int radius,
                        CDDColor c)
   {
      int Locked = dest->Stats.fLocked;
      int dx=0, dy=radius, s=3-2*radius;
      CDDErrors ret;

      if (!Locked)
      {
         ret = CD->Lock(dest);
         if (ret != CDD_NOERROR)
         {
            HRESULT hRet = CD->GetLastDDError();
            if (hRet == DDERR_SURFACELOST)
            {
               if (CD->RestoreAll() != CDD_NOERROR) return 2;
               if (CD->Lock(dest)   != CDD_NOERROR) return 3;
            }
            else return 1;
         }
      }

      for(; dx<=dy; dx++)
      {
         Plot(dest, x+dx, y+dy, c);
         Plot(dest, x+dx, y-dy, c);
         Plot(dest, x-dx, y+dy, c);
         Plot(dest, x-dx, y-dy, c);
         Plot(dest, x+dy, y+dx, c);
         Plot(dest, x+dy, y-dx, c);
         Plot(dest, x-dy, y+dx, c);
         Plot(dest, x-dy, y-dx, c);
      
         if(s<0) s+=4*dx+6;
         else
         {
            s+=4*(dx-dy)+10;
            dy--;
         }
      }

      if (!Locked) CD->Unlock(dest);
      return 0;
   } /* Circle */
}

