#ifndef _LEVEL_H
#define _LEVEL_H

#include <vector>
#include "Graphics\Primdraw.h"

namespace Maps
{
   class Vertex;
   class Line;
   class Sector;
   int FindNewPoint(Sector *s, Line *li, int sectsize, Vertex *);

   class Level
   { 
      public:
         struct Path
         {
            Vertex *Pos;
            int     NumNodes;
      
            Path() : Pos(NULL) { }
            ~Path();
         };
         Level()
         {
            NumVertices = NumLines = NumSectors = 0;
            ClearGrid();
         }
         ~Level();
         void    Dig(int inner, int outer, int roominess, int sectsize);
         void    Verify();
         void    Draw(Graphics::PrimDraw *pd, CDDSurface *s, int xc, int yc);
         Path  * FindPath(Sector *start, Sector *end);
         Path  * FindPath(Vertex start, Vertex end);

      private:
public:
         struct PathNode
         {
            PathNode *Parent;
            Sector   *Sector;
            DWORD     Cost, Score;
         };
         struct PathNodeList
         {
            std::vector<PathNode *> List;
            int Num;
         };
         PathNodeList Open, Closed;

         std::vector<Vertex *> Vertices;
         std::vector<Line *>   Lines;
         std::vector<Sector *> Sectors;
         int  NumVertices, NumLines, NumSectors;
         std::vector<Sector *> *Grid;
         int  MinX, MinY, MaxX, MaxY, Xscale, Yscale, GridRes;


         Vertex *AddVertex(int x, int y);
         Line   *AddLine(Vertex *v1, Vertex *v2);
         Sector *AddSector(Line *l1, Line *l2, Line *l3);
         Sector *MakeSector(int x1, int y1, int x2, int y2, int x3, int y3);
         Sector *RandomSector(int minNeighbors, int maxNeighbors);
         int     RemoveVertex(Vertex *v);
         int     RemoveLine(Line *l);
         void    SmoothEdges();
         inline void CheckMinMax(Vertex *);
         void    MakeGrid(int res);
         void    AddSectToGrid(Sector *s);
         void    ClearGrid();
         Sector *FindSector(Vertex v);
         inline bool CheckSectorBounds(Sector *s, Vertex v);
         bool    CheckSectorTri(Sector *s, Vertex v);
          
         inline void Push(PathNodeList *list, PathNode *);
         inline PathNode * Pop();
         inline PathNode * FindNode(PathNodeList *list, Sector *sect);
         int Heuristic(Sector *, Sector *);
         void PushNeighbors(PathNode *, Sector *);
         Path * ConstructPath(PathNode *node);
   };

   class Vertex
   {
      public:
         long X, Y;
         Vertex() : X(0), Y(0) { }
         Vertex(int xc, int yc) : X(xc), Y(yc) { }
         void Rotate(Vertex center);
         int  Distance(Vertex v);
         int  Distance_squared(Vertex v);

         friend class Line;
         friend class Sector;
         friend class Level;
         friend int FindNewPoint(Sector *s, Line *li, int sectsize, Vertex *);
   };

   class Sector
   {
      private:
         Line   *Lines[3];
         Sector *Neighbors[3];
         Vertex  Centroid;
         int     NumNeighbors;
         
      public:
         Sector(Line *l1, Line *l2, Line *l3)
         {
            Lines[0] = l1, Lines[1] = l2, Lines[2] = l3;
            Neighbors[0] = Neighbors[1] = Neighbors[2] = NULL;
            NumNeighbors = 0;
         }
         Line * RandomLine(bool blocking);
         Vertex FindCentroid();
         void   AddNeighbor(Sector *s);
         int    Overlaps(Sector s);
         RECT   BoundingBox();

         friend class Level;
         friend int FindNewPoint(Sector *s, Line *li, int sectsize, Vertex *);
   };

   class Line
   {
      private:
         Vertex *V1, *V2;
         bool    Blocking;
         
      public:
         Line() : Blocking(false) { }
         Line(Vertex *vt1, Vertex *vt2) : V1(vt1), V2(vt2), Blocking(true) { }
         int  Intersects(Line l);
         inline int Intersects2(Line l); // shared vertices dont count as intersection
         int  Length();
         int  Length_squared();
         inline void Draw(Graphics::PrimDraw *pd, CDDSurface *surf, int xc, int yc);

         friend class Sector;
         friend class Level;
         friend int FindNewPoint(Sector *s, Line *li, int sectsize, Vertex *);
   };
}

#endif
