#include <math.h>
#include "GenMath.h"
#include "TrigTables.h"

namespace Math
{
   const double PI = 3.1415926535897932384626433832795;

   int FindAngle(int x1, int y1, int x2, int y2)
   {
      int xd = x2 - x1, yd = y2 - y1;
      // handle horizontal lines to avoid divide-by-zero
      if (!yd) return (x1 <= x2) ? 64 : 192;
      int ang = (int)(atan((double)xd / yd) / RADSTO256);

      return (yd < 0) ? ((xd < 0) ? (256 - ang) : -ang) : 128 - ang;
   }
}
