#include <time.h>
#include <assert.h>
#include "Random.h"

namespace Math
{
   void Random::Randomize()
   {
      Randomize(time(NULL));
   } /* Randomize() */


   int Random::RandPeak(int min, int max)
   {
      double num = (Rand(min, max) + Rand(min, max))/2.0;
      if (num>=0.0) return (int)(num+0.5);
      else return (int)(num-0.5);
   } /* RandPeak(int min, int max) */


   int Random::RandSlope(int low, int high)
   {
      int num;

      if(low<=high)
      {
         num = Rand(low, high) + Rand(low, high) - low;
         if(num>high) num = high+high + 1 - num;
         assert(num >= low && num <= high);
      }
      else
      {
         num = high - RandSlope(high, low) + low;
         assert(num <= low && num >= high);
      }

      return num;
   } /* RandSlope */

      
   int Random::RandPeak(int min, int peak, int max)
   {
      int num;

      if ((max - peak) + (peak - min)) do num = Rand(min, max); while(num == peak);
      if (num<peak) num = RandSlope(min, peak);
      else num = RandSlope(max, peak);

      assert(num >= min && num <= max);
      return num;
   } /* RandPeak(int min, int peak, int max) */


   int Random::RandPeakSym(int min, int peak, int max)
   {
      int d1 = peak - min, d2 = max - peak;
      int num;

      if (d1>d2) do num = RandPeak(min, peak+d1); while(num > max);
      else if (d1<d2) do num = RandPeak(peak-d2, max); while(num < min);
      else return RandPeak(min, max);
      
      assert(num >= min && num <= max);
      return num;
   } /* RandPeakSym */


   int Random::RandPeakCliff(int min, int peak, int max)
   {
      if (Rand() & 1)
      {
         return RandSlope(min, peak);
      }
      else return RandSlope(max, peak);
   } /* RandPeakCliff */
}
