#ifndef _RANDOM_H
#define _RANDOM_H


/******
   Implementation of the Random class, which generates random numbers.
   By Adam Milazzo, written in quite a hurry from scratch for the Rolf project.
******/


#include <stdlib.h>

namespace Math
{
   class Random
   {
      public:
         // change the random number seed
         void Randomize();
         void Randomize(unsigned int seed)
         {
            srand(seed);
         }

         // returns a random number from 0 to RAND_MAX
         int Rand()
         {
            return rand();
         }

         /******
            With all of these functions, min and max are inclusive and it is
            assumed that min <= peak <= min. Dont worry about using the peaked
            functions, they are very fast as they do not base their values on
            mathematical curves, but bi-linear approximations of those curves.
            (Yes, I'm trying to make it sound smart! It's really nothing too
            special :)  I may add true curved functions if I see the need..
            Oh and one more thing: these functions assume that min and max
            are less than or equal to RAND_MAX and also that
            (max-min+1) <= RAND_MAX.. I should stop rambling and start coding!
         ******/

         // returns random # from 0 to max, linear distribution
         int Rand(int max)
         {
            return rand() % (max+1);
         } /* Rand(int max) */
         
         // returns random # from min to max, linear distribution
         int Rand(int min, int max)
         {
            return min + rand() % (max-min+1);
         } /* Rand(int min, int max) */
         
         // returns double from 0 to 1
         double RandReal()
         {
            return rand() / (double)RAND_MAX;
         } /* RandReal */

         
         /* returns random # from low to high, with low having the lowest
            chance of being returned and high having the highest.
         */
         inline int RandSlope(int low, int high);


         /******
            For the following functions, 'peak' has the highest chance of being
            returned and min/max have the same lowest chance, except for
            RandPeakSym(), in which only one of min or max may have the lowest
            chance.
         ******/


         /* returns # from min to max, symmetric peaked distribution, so that
            the center has the highest chance of being returned and min and
            max both have the lowest chance of being returned
         */
         inline int RandPeak(int min, int max);

         /* returns # from min to max, non-symmetrically peaked and scaled so
            that min and max both have the lowest chance of being returned,
            and the chance that the returned number is on a given side of the
            peak depends on the distance from the end of the side to the peak
         */
         int RandPeak(int min, int peak, int max);         

         /* returns # from min to max, symmetrically peaked at peak, non-scaled
            so that two numbers equidistant from the peak have an equal chance
            of being returned.. but if the peak is not in the center of min and
            max, then min and max will have unequal chances of being returned.
            specifically, the one that has the shorter distance from the peak
            will have the same chance of being retuned as a number the same
            distance on the other side of the peak.
         */
         int RandPeakSym(int min, int peak, int max);

         /* returns # from min to max, non-symmetrically peaked at peak and
            scaled so that the number returned has a 50% chance of being on
            either side of the peak, and min and max both have the lowest
            chance of being returned.
         */
         int RandPeakCliff(int min, int peak, int max);
   };
}
#endif
