#ifndef _TRIGTABLES_H
#define _TRIGTABLES_H

namespace Math
{
   // declare RADSTO256, divide a radian by this to get a number from 0-255
   extern const double RADSTO256;

   class Sines
   {
      public:
         Sines();

         inline double Sin(register int val)
         // val 0-256 = degrees 0-360
         {
            if (val < 0) val = 256-val;
            return SinTable[val&0xFF];
         };

         inline double Cos(register int val)
         // val 0-256 = degrees 0-360
         {
            return Sin(val+64);
         };

      private:
         double SinTable[256];

   };

   // The one and only sine table
   extern Sines OnlySineTable;
}

#endif
