/* This is a special purpose file designed to improve the readability and
   maintainability of other files. Assumes Entities.h and EntitiesShared.h
   are included. */

#include <pshpack1.h>   // use 1-byte structure packing to save bandwidth

enum MessageType
{
   // Incoming Messages (from server)
   MT_LOGONACCEPTED, MT_CREATEOBJECT, MT_DELETEOBJECT, MT_UPDATEINV,
   MT_ADDPLAYER, MT_REMPLAYER, MT_UPDATEPLAYERS, MT_UPDATESTATS,
   MT_DROPPED, MT_MESSAGE,

   // Outgoing Messages (to server)
   MT_LOGON, MT_MOVETO, MT_ATTACK, MT_PICKUP, MT_DROP, MT_EQUIP,
   MT_DEEQUIP, MT_USETARG, MT_USEDIR, MT_LOGOFF
};

struct GenericMessage
{
   MessageType Type;    // Message type
   // DATA FOLLOWS STRUCT
};

// INCOMING MESSAGES (FROM SERVER)

struct MPL_OnePlayer    // a single player for the player list
{
   Entities::ObjectType ObjectIndex;   // Player object (new assumed)
   int       X, Y, Z;                  // position
   DWORD     NameLen;                  // Length of player's name
   // ASCIIZ Name follows struct
};

struct MLO_PlayerList    // the initial player list
{
   int Str, Int, Dex, Spd, Def, Attk, MaxHits;  // my attributes
   int numPlayers;                              // number of players (incl. me)
   // numPlayers MPL_OnePlayer's follow struct
};

struct MsgLogOnAccepted // log on request was accepted
{
   MessageType Type;
   DWORD       ID;      // My ID (game ID, not Dplay ID)
   int Seed;            // Random number seed
   int Depth;           // Map depth (# of levels)
   int numItems;        // Number of items
   // ITEM DATA FOLLOWS (item ID, X, Y, Z, then call Item->Load with mbinfile)
   // MLO_PlayerList struct follows
};

struct MsgCreateObject  // an object was created [on the map!]
{
   MessageType Type;
   DWORD       ID;     // object ID
   int         X,Y,Z;  // position
   // item data follows (load from binfile)
};

struct MsgDeleteObject  // an object was deleted [from the map!]
{
   MessageType Type;
   DWORD       ID;      // object ID
};

struct MsgUpdateInv     // my inventory has been updated
{
   MessageType Type;
   DWORD numRems;       // removes
   DWORD numAdds;       // additions
   // numRems IDs follow
   // numAdds IDs and item data (binfile format) if ID is invalid
};

struct MUP_OnePlayer    // a single player for the player update
{
   DWORD ID;            // player ID
   int   pX, pY, pZ;    // position
   int   vX, vY, vZ;    // velocity
   int   Direction;     // direction
};

struct MsgUpdatePlayers // update the positions of potentially visible players
{
   MessageType Type;
   DWORD       numPlayers; // number of players in the update
   // numPlayers MUP_OnePlayer's follow struct
};

struct MsgUpdateStats   // update my stats
{
   MessageType Type;
   int Str, Int, Dex, Spd, Def, Attk, MaxHits;  // my attributes
   int Weight, CurHits;
};
   
struct MsgAddPlayer     // player added to the game
{
   MessageType    Type;
   // MPL_OnePlayer struct follows
};

struct MsgRemPlayer
{
   MessageType Type;
   DWORD       ID;      // ID of player to remove
};

struct MsgDropped       // we lost connection or were kicked
{
   MessageType Type;
   enum { CONN_LOST, KICKED } Why;
};

struct MsgMessage       // printed message
{
   MessageType Type;
   DWORD       Color;   // message color
   DWORD       MsgLen;  // length of message including null
   // ASCIIZ message follows
};

// OUTGOING MESSAGES (TO SERVER)

struct MsgLogOn         // logon request
{
   MessageType Type;
   DWORD       NameLen; // my name length
   // ASCIIZ name follows struct
};

struct MsgMoveTo        // move request
{
   MessageType Type;
   int         X, Y, Z; // position
};

struct MsgAttack        // attack request
{
   MessageType Type;
   DWORD       ID;      // player ID
};

struct MsgPickup        // pickup object request
{
   MessageType Type;
   DWORD       ID;      // object ID
};

struct MsgDrop          // dropping an object
{
   MessageType Type;
   DWORD       ID;      // ID of object
   int         X, Y, Z; // position
};

struct MsgEquip
{
   MessageType Type;
   DWORD       ID;      // ID of object
   Entities::EquipPlace EP; // where it was equipped
};

struct MsgDeEquip
{
   MessageType Type;
   Entities::EquipPlace EP; // where it was taken from
};

struct MsgUseTarg       // use item on target
{
   MessageType Type;
   DWORD       ObjID;   // object id
   DWORD       TargID;  // target id
};

struct MsgUseDir        // use item in a direction
{
   MessageType Type;
   DWORD       ObjID;   // object id
   int         Direction; // direction
};

struct MsgLogOff        // client is logging off
{
   MessageType Type;
};

#include <poppack.h>    // restore old structure packing
