#ifndef _OVERSEER_H
#define _OVERSEER_H

#include <windows.h>
#include <dplay.h>
#include <vector>
#include <list>
#include "IntrFace\CDDraw.h"
#include "IntrFace\BasicDP.h"
#include "Graphics\PrimDraw.h"
#include "Entities\Item.h"
#include "Entities\Player.h"

class OverSeer
{
   public:
      OverSeer();
      ~OverSeer();

      int  Init(CDDraw *cd, BasicDP *bdp);   // assumes 'bdp' is connected
      void Deinit();

      int  LogOn (char *name, DWORD msTimeout);
      void LogOff(DWORD msTimeout);

      int  MoveTo(int x, int y, int z);
      int  Attack(DWORD id);

      int  PickUp(DWORD id);
      int  Drop  (DWORD id);
      int  Equip (DWORD id, Entities::EquipPlace ep);
      int  DeEquip(Entities::EquipPlace ep);

      int  UseOnTarget(DWORD ObjID, DWORD TargID);
      int  UseInDirection(DWORD ObjID, int dir);

      int  Draw(CDDSurface *dest);
      bool NeedRedraw();

   private:
      // Drawing stuff
      Graphics::PrimDraw PrimD;
      bool               ScreenUpdated;

      // DPlay stuff
      BasicDP          *BDP;
      LPDIRECTPLAY4A    pDP;
      DWORD             NetID;
      int               CreateConnection();
      void              DestroyConnection();

      // Multithread stuff
      HANDLE   hThread, hMsgEvent, hKillEvent;
      CRITICAL_SECTION  OS_CS;
      int      InitThread();
      void     DeinitThread();
      static DWORD WINAPI ThreadFunc(LPVOID cls);

      // Player management
      std::vector<Entities::Player *> Players;
      Entities::Player               *myPlayer;
      int                             LastPlayer;
      void    AddPlayer(Entities::Player *player);
      void    RemPlayer(DWORD id);
      void    ClearPlayers();

      // Item management
      struct ItemList
      {
         std::vector<Entities::Item *> List;
         int LastItem;
      };
      ItemList MapItems;
      ItemList InvItems;
      void AddItem   (ItemList *list, Entities::Item *);
      void RemItem   (ItemList *list, int pos);
      void DelItem   (ItemList *list, DWORD id);
      int  FindItem  (ItemList *list, DWORD id);
      bool IsItemID  (DWORD id);
      void ClearItems();
      
      // Map management
      int  InitMap(int seed, int depth);

      // Game Message stuff
      struct LoggedMsg
      {
         std::string Str;
         DWORD       Color;
      };
      std::vector<LoggedMsg *> MessageLog;
      int  AddLoggedMessage(DWORD color, const char *str);
      void ClearMessageLog();

      // Overall management
      void ResetState();
      
      // Network Message stuff
      void *RecvBuffer, *SendBuffer;
      DWORD RecvBufLen,  SendBufLen;
      volatile bool LoggedOn;
      int   SendMessage(void *msg, DWORD msglen, bool guaranteed);
      int   FakeMessage(void *msg, DWORD msglen);
      void  EnlargeRecvBuf(DWORD newsize);
      int   HandleMsg(DWORD, DWORD);
      int   HandleLogonAccept();
      int   HandleCreateObject();
      int   HandleDeleteObject();
      int   HandleUpdateInv();
      int   HandleUpdatePlayers();
      int   HandleUpdateStats();
      int   HandleAddPlayer();
      int   HandleRemPlayer();
      int   HandleDropped();
      int   HandlePrintedMessage();

      #include "Network\NetMsgs.h"  // Yes, a #include inside the declaration
};

#endif
