#include "VectObject.h"

namespace Vectors
{
   Graphics::PrimFactory VectObject::PF;     // define static member

   // BEGIN VECTOBJECT IMPLEMENTATION
   
   VectObject::VectObject(VectObject &vo)
   {
      int i, num = vo.Prims.size();
      Prims.resize(num);
      for(i=0;i<num;i++) Prims[i] = vo.Prims[i]->Make_Copy();
      
      num = vo.Colors.size();
      Colors.resize(num);
      for(i=0;i<num;i++) Colors[i] = vo.Colors[i];

      Bounds = vo.Bounds;
   } /* Copy Constructor */


   VectObject::~VectObject()
   {
      int i, num = Prims.size();
      for(i=0;i<num;i++) delete Prims[i];
   } /* Destructor */


   int VectObject::Draw(Graphics::PrimDraw *pd, CDDSurface *dest, int xc, int yc,
                        DWORD flags, CDDColor c)
   {
      int num = Prims.size();

      if (flags & VO_COLOROVERRIDE)
      {
         for(int i=0;i<num;i++) Prims[i]->Draw(pd, dest, xc, yc, c);
      }
      else
      {
         for(int i=0;i<num;i++) Prims[i]->Draw(pd, dest, xc, yc, Colors[i]);
      }
      return 0;
   } /* Draw */


   void VectObject::Rotate(int angle)
   {
      int num = Prims.size();
      for(int i=0;i<num;i++) Prims[i]->Rotate(angle);
   } /* Rotate */


   void VectObject::Scale(double scale)
   {
      int num = Prims.size();
      for(int i=0;i<num;i++) Prims[i]->Scale(scale);
   } /* Scale */


   int VectObject::Load(binfile *file)
   {
      int numPrims,i=0;
      Graphics::PrimType type;

      file->read(&numPrims, sizeof(numPrims));
      Prims.resize(numPrims);
      Colors.resize(numPrims);

      for(i=0;i<numPrims;i++)
      {
         file->read(&type, sizeof(type));
         Prims[i] = PF.New(type);
         Prims[i]->Load(file);
         file->read(&Colors[i], sizeof(CDDColor));
      }
      file->read(&Bounds, sizeof(Bounds));
      return 0;
   } /* Load */


   int VectObject::Save(binfile *file)
   {
      int numPrims=Prims.size(),i=0;
      Graphics::PrimType type;

      file->write(&numPrims, sizeof(numPrims));

      for(i=0;i<numPrims;i++)
      {
         type = Prims[i]->MyType();
         file->write(&type, sizeof(type));
         Prims[i]->Save(file);
         file->write(&Colors[i], sizeof(CDDColor));
      }
      file->write(&Bounds, sizeof(Bounds));
      return 0;
   } /* Save */
}
