#ifndef _VECTOBJECT_H
#define _VECTOBJECT_H

#include <vector>
#include "Binfile\Binfile.h"
#include "IntrFace\CDDraw.h"
#include "Graphics\PrimDraw.h"
#include "Graphics\Primitives.h"

namespace Vectors
{
   class VectObject
   {
      public:
         enum // Flags
         {
            VO_COLOROVERRIDE = 1   // Override the primitives default colors with the specified color
         };

         VectObject() { };
         VectObject(VectObject &vo);
         ~VectObject();
         int  Draw(Graphics::PrimDraw *, CDDSurface *, int xc, int yc, DWORD flags, CDDColor c);
         bool Collision(VectObject *obj2, int x1, int y1, int x2, int y2)
         {
            int bd = Bounds + obj2->Bounds;
            int xd = x1-x2, yd = y1-y2;
            int dist = xd*xd + yd*yd;
            return dist > bd*bd;
         };
         void Rotate(int angle);
         void Scale(double scale);
         int  Load(binfile *file);
         int  Save(binfile *file);

      private:
         static Graphics::PrimFactory PF;  // The one and only primitive factory
         std::vector<Graphics::Primitive *>  Prims;
         std::vector<CDDColor>               Colors;
         DWORD                               Bounds;  // Bounding circle radius
   };
}

#endif
