#ifndef _VECTOR_H
#define _VECTOR_H

#include <math.h>
#include "Math\TrigTables.h"

namespace Vectors
{
   template<class T> class Vector
   {
      public:
         T X, Y, Z;
         Vector() : X(0), Y(0), Z(0) { };
         Vector(T v) : X(v), Y(v), Z(v) { };
         Vector(T x, T y, T z) : X(x), Y(y), Z(z) { };

         double      Length();
         T           Length_Sqr()
         {
            return X * Y * Z;
         };

         Vector<T>   Normalize();

         inline Vector<T> operator- ();
         inline Vector<T> operator+ (Vector<T> rhs);
         inline Vector<T> operator+=(Vector<T> rhs);
         inline Vector<T> operator- (Vector<T> rhs);
         inline Vector<T> operator-=(Vector<T> rhs);
         inline Vector<T> operator* (Vector<T> rhs); // THIS IS A DOT PRODUCT
         inline Vector<T> operator*=(Vector<T> rhs); // THIS IS A DOT PRODUCT
         inline Vector<T> operator/ (Vector<T> rhs);
         inline Vector<T> operator/=(Vector<T> rhs);

         inline Vector<T> operator+ (T rhs);
         inline Vector<T> operator+=(T rhs);
         inline Vector<T> operator- (T rhs);
         inline Vector<T> operator-=(T rhs);
         inline Vector<T> operator* (T rhs);
         inline Vector<T> operator*=(T rhs);
         inline Vector<T> operator/ (T rhs);
         inline Vector<T> operator/=(T rhs);

      private:
         static Math::Sines &SineTab;

         friend Vector<T> operator+ (T lhs, Vector<T> rhs);
         friend Vector<T> operator- (T lhs, Vector<T> rhs);
         friend Vector<T> operator* (T lhs, Vector<T> rhs);
         friend Vector<T> operator/ (T lhs, Vector<T> rhs);
         friend Vector<T> Normal      (Vector<T>);
         friend Vector<T> CrossProduct(Vector<T>, Vector<T>);
         friend Vector<T> Rotated     (Vector<T>, int, int, int);
         friend Vector<T> RotatedX    (Vector<T>, int);
         friend Vector<T> RotatedY    (Vector<T>, int);
         friend Vector<T> RotatedZ    (Vector<T>, int);
   };

   template<class T> inline Vector<T> operator+ (T lhs, Vector<T> rhs);
   template<class T> inline Vector<T> operator- (T lhs, Vector<T> rhs);
   template<class T> inline Vector<T> operator* (T lhs, Vector<T> rhs);
   template<class T> inline Vector<T> operator/ (T lhs, Vector<T> rhs);

   template<class T> inline Vector<T> Normal      (Vector<T>);
   template<class T> inline Vector<T> CrossProduct(Vector<T>, Vector<T>);
   template<class T> inline Vector<T> Rotated     (Vector<T>, int, int, int);
   template<class T> inline Vector<T> RotatedX    (Vector<T>, int);
   template<class T> inline Vector<T> RotatedY    (Vector<T>, int);
   template<class T> inline Vector<T> RotatedZ    (Vector<T>, int);

   #include "Vector_impl.h"
}

#endif
