/* Special purpose file: Used to improve readability of Vector.h.  Do not
   directly include this file. Thank you. Have a nice day. Move on please. */

   template<class T> double Vector<T>::Length()
   {
      return sqrt(Length_Sqr());
   }

   template<class T> Vector<T> Vector<T>::Normalize()
   {
      return *this = Normal(*this);
   }

   template<class T> Vector<T> Normal(Vector<T> vect)
   {
      double scalar = vect.Length();
      if (scalar == 0.0) return Vector<T>(1, 1, 1);
      else return vect / scalar;
   }

   template<class T> Vector<T> CrossProduct(Vector<T> lhs, Vector<T> rhs)
   {
      return Vector<T>(lhs.Y * rhs.Z - lhs.Z * rhs.Y,
                       lhs.Z * rhs.X - lhs.X * rhs.Z,
                       lhs.X * rhs.Y - lhs.Y * rhs.X);
   }

   template<class T> Vector<T> Rotated(Vector<T> vect, int xa, int ya, int za)
   {
      Vector<T> temp = RotatedX(vect, xa);
      temp = RotatedY(temp, ya);
      return RotatedZ(temp, za);
   };

   template<class T> Vector<T> RotatedX(Vector<T> vect, int angle)
   {
      return Vector<T>(vect.X,
                       vect.Y * vect.SineTab.Sin(angle) + vect.Z * vect.SineTab.Cos(angle),
                       vect.Y * vect.SineTab.Cos(angle) - vect.Z * vect.SineTab.Sin(angle));
   }

   template<class T> Vector<T> RotatedY(Vector<T> vect, int angle)
   {
      return Vector<T>(vect.X * vect.SineTab.Sin(angle) + vect.Z * vect.SineTab.Cos(angle),
                       vect.Y,
                       vect.X * vect.SineTab.Cos(angle) - vect.Z * vect.SineTab.Sin(angle));
   }

   template<class T> Vector<T> RotatedZ(Vector<T> vect, int angle)
   {
      return Vector<T>(vect.X * vect.SineTab.Cos(angle) - vect.Y * vect.SineTab.Sin(angle),
                       vect.X * vect.SineTab.Cos(angle) + vect.Y * vect.SineTab.Cos(angle),
                       vect.Z);
   }

   template<class T> Vector<T> Vector<T>::operator-()
   {
      return Vector<T>(-X, -Y, -Z);
   }

   template<class T> Vector<T> Vector<T>::operator+(Vector<T> rhs)
   {
      Vector<T> temp = *this;
      temp += rhs;
      return temp;
   }

   template<class T> Vector<T> Vector<T>::operator+=(Vector<T> rhs)
   {
      X += rhs.X, Y += rhs.Y, Z += rhs.Z;
      return *this;
   }

   template<class T> Vector<T> Vector<T>::operator-(Vector<T> rhs)
   {
      Vector<T> temp = *this;
      temp -= rhs;
      return temp;
   }

   template<class T> Vector<T> Vector<T>::operator-=(Vector<T> rhs)
   {
      X -= rhs.X, Y -= rhs.Y, Z -= rhs.Z;
      return *this;
   }

   template<class T> Vector<T> Vector<T>::operator*(Vector<T> rhs)
   {
      Vector<T> temp = *this;
      temp *= rhs;
      return temp;
   }

   template<class T> Vector<T> Vector<T>::operator*=(Vector<T> rhs)
   {
      X *= rhs.X, Y *= rhs.Y, Z *= rhs.Z;
      return *this;
   }

   template<class T> Vector<T> Vector<T>::operator/(Vector<T> rhs)
   {
      Vector<T> temp = *this;
      temp /= rhs;
      return temp;
   }

   template<class T> Vector<T> Vector<T>::operator/=(Vector<T> rhs)
   {
      X /= rhs.X, Y /= rhs.Y, Z /= rhs.Z;
      return *this;
   }

   template<class T> Vector<T> Vector<T>::operator+(T rhs)
   {
      Vector<T> temp = *this;
      temp += rhs;
      return temp;
   }

   template<class T> Vector<T> Vector<T>::operator+=(T rhs)
   {  
      X += rhs, Y += rhs, Z += rhs;
      return *this;
   }

   template<class T> Vector<T> Vector<T>::operator-(T rhs)
   {
      Vector<T> temp = *this;
      temp -= rhs;
      return temp;
   }

   template<class T> Vector<T> Vector<T>::operator-=(T rhs)
   {  
      X -= rhs, Y -= rhs, Z -= rhs;
      return *this;
   }

   template<class T> Vector<T> Vector<T>::operator*(T rhs)
   {
      Vector<T> temp = *this;
      temp *= rhs;
      return temp;
   }

   template<class T> Vector<T> Vector<T>::operator*=(T rhs)
   {  
      X *= rhs, Y *= rhs, Z *= rhs;
      return *this;
   }

   template<class T> Vector<T> Vector<T>::operator/(T rhs)
   {
      Vector<T> temp = *this;
      temp /= rhs;
      return temp;
   }

   template<class T> Vector<T> Vector<T>::operator/=(T rhs)
   {  
      X /= rhs, Y /= rhs, Z /= rhs;
      return *this;
   }

   template<class T> Vector<T> operator+ (T lhs, Vector<T> rhs)
   {
      return rhs + lhs;
   }

   template<class T> Vector<T> operator- (T lhs, Vector<T> rhs)
   {
      return Vector<T>(lhs - rhs.X, lhs - rhs.Y, lhs - rhs.Z);
   }

   template<class T> Vector<T> operator* (T lhs, Vector<T> rhs)
   {
      return rhs * lhs;
   }

   template<class T> Vector<T> operator/ (T lhs, Vector<T> rhs)
   {
      return Vector<T>(lhs / rhs.X, lhs / rhs.Y, lhs / rhs.Z);
   }

