﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Net;

namespace ThisAmericanLife
{
  class Program
  {
    static int Main(string[] args)
    {
      string id, outputFileName;
      if(!ParseArguments(args, out id, out outputFileName))
      {
        Console.WriteLine("Downloads a show from the This American Life website.");
        Console.WriteLine("USAGE: taldl showNumber [outputFile.mp3]");
        Console.WriteLine("EXAMPLE: taldl 1 firstShow.mp3");
        return 1;
      }

      try
      {
        string streamBase = "http://stream.thisamericanlife.org/" + id + "/stream/", descriptorUri = streamBase + id + "_64k.m3u8";
        Console.WriteLine("Fetching stream descriptor from " + descriptorUri);
        MemoryStream descriptorStream = new MemoryStream();
        DownloadTo(descriptorUri, descriptorStream);

        Console.WriteLine("Opening output file " + outputFileName);
        using(FileStream outputStream = new FileStream(outputFileName, FileMode.Create, FileAccess.Write))
        {
          List<string> chunks = new List<string>();
          descriptorStream.Position = 0;
          using(StreamReader reader = new StreamReader(descriptorStream))
          {
            while(true)
            {
              string line = reader.ReadLine();
              if(line == null) break;
              line = line.Trim();
              if(line.Length != 0 && line[0] != '#') chunks.Add(line);
            }
          }

          if(chunks.Count != 0)
          {
            Console.Write("Downloading chunk ");
            string suffix = "/" + chunks.Count.ToString(CultureInfo.InvariantCulture) + "...";
            for(int lastLength=0, i=0; i<chunks.Count; i++)
            {
              string chunkStr = (i+1).ToString(CultureInfo.InvariantCulture) + suffix;
              Console.Write(new string('\b', lastLength));
              Console.Write(chunkStr);
              lastLength = chunkStr.Length;
              DownloadTo(streamBase + chunks[i], outputStream);
            }
            Console.WriteLine();
          }
        }
        Console.WriteLine("Done.");
        return 0;
      }
      catch(Exception ex)
      {
        Console.WriteLine("ERROR: " + ex.GetType().Name + " - " + ex.Message);
        return 2;
      }
    }

    static void DownloadTo(string uri, Stream destStream)
    {
      using(WebResponse response = WebRequest.Create(uri).GetResponse())
      using(Stream responseStream = response.GetResponseStream())
      {
        responseStream.CopyTo(destStream);
      }
    }

    static bool ParseArguments(string[] args, out string showId, out string outputFileName)
    {
      showId         = null;
      outputFileName = null;
      int id;
      if(args.Length < 1 || args.Length > 2 || !int.TryParse(args[0], out id)) return false;
      showId         = id.ToString(CultureInfo.InvariantCulture);
      outputFileName = args.Length < 2 ? showId + ".mp3" : args[1];
      return true;
    }
  }
}
